/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: RequestTemplateFilter.java 69536 2013-01-16 13:41:41Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.container.requestcontext.illegalstate;

import java.io.IOException;
import java.lang.reflect.Method;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

public abstract class RequestTemplateFilter extends TemplateFilter implements ContainerRequestFilter {
	@Override
	public void filter(ContainerRequestContext requestContext) throws IOException {
		this.requestContext = requestContext;
		String operation = requestContext.getHeaderString(OPERATION);
		Method[] methods = getClass().getMethods();
		for (Method method : methods)
			if (operation.equalsIgnoreCase(method.getName())) {
				try {
					method.invoke(this);
					if (entity != null) {
						Response response = Response.ok(entity).build();
						requestContext.abortWith(response);
					}
					return;
				} catch (Exception e) {
					e.printStackTrace();
					Response response = Response
							.status(Status.SERVICE_UNAVAILABLE)
							.entity(e.getMessage()).build();
					requestContext.abortWith(response);
				}
			}
		//If method not found, it is response context operation
	}

}
