/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ResponseFilter.java 69536 2013-01-16 13:41:41Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.container.requestcontext.illegalstate;

import java.io.ByteArrayInputStream;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

import com.sun.ts.tests.jaxrs.common.impl.SecurityContextImpl;

@Provider
public class ResponseFilter extends ResponseTemplateFilter {
	public void abortWith() {
		try {
			requestContext.abortWith(Response.ok().build());
			setEntity(NOEXCEPTION);
		} catch (IllegalStateException e) {
			setEntity(ISEXCEPTION);
		}
	}	

	public void setEntityStream() {
		try {
			ByteArrayInputStream bais = new ByteArrayInputStream(
					NOEXCEPTION.getBytes());
			requestContext.setEntityStream(bais);
			setEntity(NOEXCEPTION);
		} catch (IllegalStateException e) {
			setEntity(ISEXCEPTION);
		}
	}

	public void setSecurityContext() {
		SecurityContext ctx = new SecurityContextImpl();
		try {
			requestContext.setSecurityContext(ctx);
			setEntity(NOEXCEPTION);
		} catch (IllegalStateException e) {
			setEntity(ISEXCEPTION);
		}
	}

}
