/*
 * $Id$
 *
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jaxrs.ee.rs.ext.exceptionmapper;

import java.io.IOException;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/**
 * This class is used by com.sun.ts.tests.jaxrs.ee.rs.ext.providers.ProvidersServlet  
 */
@Provider
public class AnyExceptionExceptionMapper implements ExceptionMapper<Exception>{
	
	@Override
	public Response toResponse(Exception arg0) {
		Status status = Status.NO_CONTENT;
		if (arg0 instanceof WebApplicationException)
			return ((WebApplicationException)arg0).getResponse();
		else if (arg0 instanceof RuntimeException)
			throw new RuntimeException("CTS Test RuntimeException", arg0);
		else if (arg0 instanceof IOException)
			status = Status.SERVICE_UNAVAILABLE;
		else if (arg0 != null)
			status = Status.NOT_ACCEPTABLE;
		return Response.status(status).build();
	}

}
