/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: EntityMessageWriter.java 69858 2013-02-06 15:55:21Z supol $
 */
package com.sun.ts.tests.jaxrs.ee.rs.ext.messagebodyreaderwriter;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.sun.ts.tests.jaxrs.common.AbstractMessageBodyRW;

/**
 * This class is used by
 * com.sun.ts.tests.jaxrs.ee.rs.ext.providers.ProvidersServlet
 */
@Provider
public class EntityMessageWriter extends AbstractMessageBodyRW implements
		MessageBodyWriter<ReadableWritableEntity> {

	@Override
	public long getSize(ReadableWritableEntity t, Class<?> type,
			Type genericType, Annotation[] annotations, MediaType mediaType) {
		return t.toXmlString().length();
	}

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		String path = getPathValue(annotations);
		if (path == null)
			return false;
		path = path.toLowerCase();
		boolean writable = path.contains("body");
		writable |= path.contains("head");
		writable |= path.contains("ioexception");
		writable &= MediaType.TEXT_XML_TYPE.isCompatible(mediaType);
		writable &= ReadableWritableEntity.class.isAssignableFrom(type);
		return writable;
	}

	@Override
	public void writeTo(ReadableWritableEntity t, Class<?> type,
			Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		String path = getPathValue(annotations).toLowerCase();
		if (path.contains("body"))
			entityStream.write(t.toXmlString().getBytes());
		else if (path.contains("head"))
			httpHeaders.add(ReadableWritableEntity.NAME, t.toXmlString());
		else if (path.contains("ioexception"))
			throw new IOException("CTS test IOException");
	}

}
