/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.ee.rs.options;

import javax.ws.rs.core.Response.Status;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSClient extends JAXRSCommonClient {
	private static final long serialVersionUID = 1L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_ee_rs_options_web/Options");
	}

	/**
	 * Entry point for different-VM execution.  It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */
	/*
	 * @testName: optionsTest
	 * @assertion_ids: JAXRS:SPEC:18; JAXRS:SPEC:18.1;	
	 * @test_Strategy: Call a method annotated with a request method designator for OPTIONS
	 */
	public void optionsTest() throws Fault {
		setProperty(REQUEST, buildRequest("OPTIONS", "options"));
		setProperty(STATUS_CODE, getStatusCode(Status.ACCEPTED));
		invoke();
	}
	
	/*
	 * @testName: autoResponseTest
	 * @assertion_ids: JAXRS:SPEC:18; JAXRS:SPEC:18.2;	
	 * @test_Strategy: Generate an automatic response using the metadata 
	 * 					provided by the JAX-RS annotations on the matching
	 *					class and its methods.
	 */
	public void autoResponseTest() throws Fault {
		setProperty(REQUEST, buildRequest("OPTIONS", "get"));
		setProperty(STATUS_CODE, "!" + getStatusCode(Status.NOT_FOUND));
		invoke();
	}	
}
