/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.ee.rs.put;


import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value = "/PutTest")

public class HttpMethodPutTest {

    static String html_content =
            "<html>" + "<head><title>CTS-get text/html</title></head>" +
            "<body>CTS-put text/html</body></html>";

    @PUT
    @Produces(value = "text/plain")
    public String getPlain() {
        return "CTS-put text/plain";
    }

    @PUT
    @Produces(value = "text/html")
    public String getHtml() {
        return html_content;
    }

    @PUT
    @Path(value = "/sub")
    @Produces(value = "text/html")
    public String getSub() {
        return html_content;
    }
}
