/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: JAXRSClient.java 75067 2017-06-14 15:43:37Z jsupol $ 
 */

package com.sun.ts.tests.jaxrs.jaxrs21.ee.priority;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSClient extends JAXRSCommonClient {

	private static final long serialVersionUID = 21L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_jaxrs21_ee_priority_web");
	}


	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}


	/* Run test */
	
	/*
	 * @testName: exceptionMapperPriorityTest
	 * @assertion_ids: JAXRS:SPEC:127;
	 * @test_Strategy:
	 */
	public void exceptionMapperPriorityTest() throws Fault {		
		setProperty(Property.REQUEST, buildRequest(Request.GET, "exception"));
		setProperty(Property.SEARCH_STRING, ExceptionMapperOne.class.getName());
		invoke();
	}	
	
	/*
	 * @testName: paramConverterPriorityTest
	 * @assertion_ids: JAXRS:SPEC:127;
	 * @test_Strategy:
	 */
	public void paramConverterPriorityTest() throws Fault {		
		setProperty(Property.REQUEST, buildRequest(Request.GET, "converter?id=something"));
		setProperty(Property.SEARCH_STRING, ParamConverterProviderOne.class.getName());
		invoke();
	}		

}
