/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: Resource.java 70976 2013-03-22 14:22:25Z supol $
 */

package com.sun.ts.tests.jaxrs.spec.context.server;

import java.util.Set;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;

import com.sun.ts.tests.jaxrs.common.provider.StringBean;

@Path("resource")
public class Resource {

	@Context
	Application application;
	@Context
	UriInfo info;
	@Context
	Request request;
	@Context
	HttpHeaders headers;
	@Context
	SecurityContext security;
	@Context
	Providers providers;
	@Context
	ResourceContext resources;
	@Context
	Configuration configration;

	@POST
	@Path("echo")
	public String returnGivenString(String string) {
		return string;
	}

	@POST
	@Path("reader")
	public String reader(StringBean bean) {
		return bean.get();
	}

	@POST
	@Path("writer")
	public StringBean writer(String entity) {
		return new StringBean(entity);
	}

	@GET
	@Path("instance")
	public String instance() {
		return StringBeanEntityProviderWithInjectables.computeMask(application,
				info, request, headers, security, providers, resources,
				configration);
	}

	@GET
	@Path("method")
	public String method(@Context Application application,
			@Context UriInfo info, @Context Request request,
			@Context HttpHeaders headers, @Context SecurityContext security,
			@Context Providers providers, @Context ResourceContext resources) {
		return StringBeanEntityProviderWithInjectables.computeMask(application,
				info, request, headers, security, providers, resources,
				configration);
	}

	@GET
	@Path("application")
	public String application(@Context Application application) {
		Set<Object> singletons = application.getSingletons();
		SingletonWithInjectables singleton = (SingletonWithInjectables) singletons
				.iterator().next();
		return singleton.getInjectedContextValues();
	}

}
