/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: TSAppConfig.java 74484 2015-05-14 13:58:48Z jsupol $
 */

package com.sun.ts.tests.jaxrs.spec.context.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;

import com.sun.ts.tests.jaxrs.common.provider.PrintingErrorHandler;

public class TSAppConfig extends Application {

	@Context
	UriInfo info;
	@Context
	Request request;
	@Context
	HttpHeaders headers;
	@Context
	SecurityContext security;
	@Context
	Providers providers;
	@Context
	ResourceContext resources;

	public java.util.Set<java.lang.Class<?>> getClasses() {
		Set<Class<?>> resources = new HashSet<Class<?>>();
		resources.add(Resource.class);
		resources.add(StringBeanEntityProviderWithInjectables.class);
		resources.add(PrintingErrorHandler.class);
		return resources;
	}

	@Override
	public Set<Object> getSingletons() {
		Object single = new SingletonWithInjectables(this);
		return Collections.singleton(single);
	}

	public String getInjectedContextValues() {
		return StringBeanEntityProviderWithInjectables.computeMask(//
				/*
				 * Spec: 9.2.1 Application Note that this cannot be injected
				 * into the Application subclass itself since this would create
				 * a circular dependency.
				 */
				this, info, request, headers, security, providers, resources,
				// Configuration injection N/A on Application
				ClientBuilder.newClient().getConfiguration());
	}
}
