/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AbstractAddInterceptor.java 69694 2013-01-30 14:54:06Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.globalbinding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

public abstract class AbstractAddInterceptor implements ReaderInterceptor,
		WriterInterceptor {

	private int amount;

	public AbstractAddInterceptor(int amount) {
		this.amount = amount;
	}

	@Override
	public void aroundWriteTo(WriterInterceptorContext context)
			throws IOException, WebApplicationException {
		String entity = (String) context.getEntity();
		Integer i = Integer.parseInt(entity);
		entity = String.valueOf(i + amount);
		context.setEntity(entity);
		context.proceed();
	}

	@Override
	public Object aroundReadFrom(ReaderInterceptorContext context)
			throws IOException, WebApplicationException {
		InputStream inputStream = context.getInputStream();
		String entity = JaxrsUtil.readFromStream(inputStream);
		Integer i = Integer.parseInt(entity);
		entity = String.valueOf(i + amount);
		context.setInputStream(new ByteArrayInputStream(entity.getBytes()));
		return context.proceed();
	}

}
