/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: TckJaxbProvider.java 69872 2013-02-06 19:07:31Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.provider.jaxbcontext;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;

@Provider
public class TckJaxbProvider implements
		MessageBodyReader<JAXBElement<String>>,
		MessageBodyWriter<JAXBElement<String>> {

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return JAXBElement.class.isAssignableFrom(type);
	}

	@Override
	public long getSize(JAXBElement<String> t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return t.getValue().length() + 2;
	}

	@Override
	public void writeTo(JAXBElement<String> t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(t.getValue().getBytes());
		entityStream.write("OK".getBytes());
	}

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return isWriteable(type, genericType, annotations, mediaType);
	}

	@Override
	public JAXBElement<String> readFrom(Class<JAXBElement<String>> type,
			Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		return null;
	}

}
