/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.spec.provider.overridestandard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class TckFileProvider extends AbstractProvider implements
		MessageBodyReader<File>, MessageBodyWriter<File> {

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return type == File.class;
	}

	@Override
	public long getSize(File t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return getLength();
	}

	@Override
	public void writeTo(File t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		FileReader fr = new FileReader(t);
		BufferedReader br = new BufferedReader(fr);
		String text = br.readLine();
		br.close();
		entityStream.write(text == null ? "".getBytes() : text.getBytes());
		entityStream.write(getWriterName().getBytes());
	}

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return isWriteable(type, genericType, annotations, mediaType);
	}

	@Override
	public File readFrom(Class<File> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		File f = File.createTempFile("tckjaxrs", "tmp");
		FileWriter fw = new FileWriter(f);
		fw.write(getReaderName());
		fw.close();
		return f;
	}

}
