/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.spec.provider.visibility;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
public class DummyWriter implements MessageBodyWriter<DummyClass> {
	private HttpHeaders headers;
	private UriInfo info;
	private Application application;
	private Request request;
	private Providers provider;

	protected DummyWriter(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application, @Context Request request,
			@Context Providers provider) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
		this.request = request;
		this.provider = provider;
	}

	public DummyWriter(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application, @Context Request request) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
		this.request = request;
	}

	public DummyWriter(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
	}

	public DummyWriter(@Context HttpHeaders headers, @Context UriInfo info) {
		super();
		this.headers = headers;
		this.info = info;
	}

	public DummyWriter(@Context HttpHeaders headers) {
		super();
		this.headers = headers;
	}

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return type == DummyClass.class;
	}

	@Override
	public long getSize(DummyClass t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return HolderClass.OK.length();
	}

	@Override
	public void writeTo(DummyClass t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(new HolderClass(headers, info, application, request,
				provider).toResponse().getEntity().toString().getBytes());
	}

}
