/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.MultiFormatPane;
import com.sun.javatest.exec.TextPane;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.Timer;

class QuestionLogBrowser
extends ToolDialog {
    private ExecModel model;
    private InterviewParameters params;
    private MultiFormatPane body;
    private FileChooser fileChooser;
    private Listener listener;
    private static final String SAVE_AS = "SaveAs";
    private static final String PRINT_SETUP = "PrintSetup";
    private static final String PRINT = "Print";
    private static final int WAIT_DIALOG_DELAY = 3000;

    QuestionLogBrowser(JComponent parent, ExecModel model, UIFactory uif) {
        super(parent, uif, "qlb");
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.params = model.getInterviewParameters();
        if (this.params == null) {
            throw new NullPointerException();
        }
        this.listener = new Listener();
    }

    @Override
    protected void initGUI() {
        this.setHelp("quLog.window.csh");
        JMenuBar mb = this.uif.createMenuBar("qlb");
        String[] fileActions = new String[]{SAVE_AS, PRINT_SETUP, PRINT};
        JMenu fileMenu = this.uif.createMenu("qlb.file", fileActions, this.listener);
        mb.add(fileMenu);
        this.setJMenuBar(mb);
        this.body = new MultiFormatPane(this.uif);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.body.setName("qlb.body");
        this.uif.setAccessibleName(this.body, "qlb.body");
        this.uif.setToolTip(this.body, "qlb");
        int dpi = this.uif.getDotsPerInch();
        this.body.setPreferredSize(new Dimension(6 * dpi, 9 * dpi));
        this.setBody(this.body);
        JButton helpBtn = this.uif.createHelpButton("qlb.help", "quLog.window.csh");
        JButton closeBtn = this.uif.createCloseButton("qlb.close");
        this.setButtons(new JButton[]{helpBtn, closeBtn}, closeBtn);
        this.setComponentListener(this.listener);
    }

    private void updateContent() {
        if (this.body == null) {
            this.initGUI();
        }
        final JDialog d = this.uif.createWaitDialog("qlb.wait", this.parent);
        File f = this.params.getFile();
        if (f == null) {
            this.setI18NTitle("qlb.title");
        } else {
            this.setI18NTitle("qlb.titleWithFile", f);
        }
        final Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    WizPrint wp = new WizPrint(QuestionLogBrowser.this.params);
                    wp.setShowResponses(true);
                    wp.setShowResponseTypes(false);
                    wp.setShowTags(true);
                    StringWriter out = new StringWriter();
                    wp.write(out);
                    QuestionLogBrowser.this.finishContentUpdate(d, out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (t.isAlive()) {
                    d.show();
                }
            }
        };
        Timer timer = new Timer(3000, al);
        timer.setRepeats(false);
        timer.start();
        t.start();
    }

    private void finishContentUpdate(final JDialog waitDialog, final StringWriter out) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                waitDialog.hide();
                MultiFormatPane multiFormatPane = QuestionLogBrowser.this.body;
                QuestionLogBrowser.this.body;
                TextPane textPane = (TextPane)multiFormatPane.getMediaPane(0);
                textPane.showText(out.toString(), "text/html");
                textPane.getCaret().setDot(0);
            }
        });
    }

    private void doSaveAs() {
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser(true);
            this.fileChooser.addChoosableExtension(".html", this.uif.getI18NString("qlb.htmlFiles"));
        }
        this.fileChooser.setDialogTitle(this.uif.getI18NString("qlb.save.title"));
        File file = null;
        block6: while (file == null) {
            String path;
            int rc = this.fileChooser.showDialog(this.parent, this.uif.getI18NString("qlb.save.btn"));
            if (rc != 0) {
                return;
            }
            file = this.fileChooser.getSelectedFile();
            if (!file.exists() && !(path = file.getPath()).endsWith(".html")) {
                file = new File(path + ".html");
            }
            if (!file.exists()) continue;
            rc = this.uif.showYesNoCancelDialog("qlb.save.warn", file);
            switch (rc) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    this.fileChooser.setSelectedFile(null);
                    file = null;
                    continue block6;
                }
            }
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(((JEditorPane)((Object)this.body.getMediaPane(0))).getText());
            ((Writer)out).close();
        }
        catch (IOException e) {
            if (!file.canWrite()) {
                this.uif.showError("qlb.save.cantWriteFile", file);
            }
            if (e instanceof FileNotFoundException) {
                this.uif.showError("qlb.save.cantFindFile", file);
            }
            this.uif.showError("qlb.save.error", new Object[]{file, e});
        }
    }

    private void doPrintSetup() {
        this.model.printSetup();
    }

    private void doPrint() {
        this.model.print(this.body);
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener,
    Interview.Observer {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(QuestionLogBrowser.SAVE_AS)) {
                QuestionLogBrowser.this.doSaveAs();
            } else if (cmd.equals(QuestionLogBrowser.PRINT_SETUP)) {
                QuestionLogBrowser.this.doPrintSetup();
            } else if (cmd.equals(QuestionLogBrowser.PRINT)) {
                QuestionLogBrowser.this.doPrint();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            QuestionLogBrowser.this.params.addObserver(this);
            QuestionLogBrowser.this.updateContent();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            QuestionLogBrowser.this.params.removeObserver(this);
        }

        @Override
        public void currentQuestionChanged(Question q) {
        }

        @Override
        public void pathUpdated() {
            QuestionLogBrowser.this.updateContent();
        }
    }
}

