/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.connector;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.common.SunRITool;
import com.sun.ant.types.Support;
import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;

public class ConnectorTool
extends SunRITool {
    private String descriptorXmlFileName = "";
    private String descriptorRuntimeXmlFileName = "";

    protected Hashtable getRarContents() {
        Hashtable<String, File> htFilesToAdd = new Hashtable<String, File>();
        Project project = this.task.getProject();
        if (this.config.supportFileSets.size() == 0) {
            Support defaultRarFileSet = new Support();
            defaultRarFileSet.setDir(this.destDir);
            defaultRarFileSet.setIncludes("*.jar, *.war");
            this.config.supportFileSets.add(defaultRarFileSet);
        }
        int n = this.config.supportFileSets.size();
        for (int i = 0; i < n; ++i) {
            Support fileSet = (Support)((Object)this.config.supportFileSets.get(i));
            File baseDir = fileSet.getDir(project);
            if (baseDir.compareTo(TSBuildListener.fClassDir) == 0) {
                project.log("ConnectorTool detects the dir for a rar fileset is class.dir.  Will reset it to dist.dir", 3);
                fileSet.setDir(this.destDir);
                baseDir = this.destDir;
            }
            DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
            String[] sFiles = scanner.getIncludedFiles();
            for (int jj = 0; jj < sFiles.length; ++jj) {
                htFilesToAdd.put(sFiles[jj], new File(baseDir, sFiles[jj]));
            }
        }
        return htFilesToAdd;
    }

    public void processRar() {
        File rarFile;
        Project project = this.task.getProject();
        Hashtable rarContents = this.getRarContents();
        if (this.needToRebuild(rarContents, rarFile = new File(this.destDir, this.config.name + ".rar"))) {
            project.log("building " + rarFile.getName() + " with " + String.valueOf(rarContents.size()) + " files", 3);
            this.writeRar(rarFile, rarContents);
        } else {
            project.log(rarFile.toString() + " is up to date.");
        }
    }

    protected void writeRar(File jarfile, Hashtable htContents) {
        String sFilesToAdd = "";
        String sJarFile = jarfile.getPath();
        if (jarfile.exists()) {
            jarfile.delete();
        }
        for (String entryName : htContents.keySet()) {
            File entryFile = (File)htContents.get(entryName);
            this.log("adding file '" + entryName + "'", 3);
            if (!sFilesToAdd.equals("")) {
                sFilesToAdd = sFilesToAdd + ":" + entryName;
                continue;
            }
            sFilesToAdd = sFilesToAdd + entryName;
        }
        String args = "-connector " + this.destDir + " " + sFilesToAdd + " " + this.config.descriptor.getPath() + " " + sJarFile;
        this.invokePackager(jarfile, args);
    }
}

