/*
 * Copyright (c) 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: EJBEmbedRunner.java 62592 2011-04-20 20:07:16Z kgrucci $
 */

package com.sun.ts.tests.common.vehicle.ejbembed;

import static com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteClientIF.TEST_PASSED;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

import javax.ejb.embeddable.EJBContainer;

import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteClientIF;
import com.sun.ts.tests.common.vehicle.ejbliteshare.ReasonableStatus;

public class EJBEmbedRunner implements VehicleRunnable {

    private static final Logger logger = Logger
            .getLogger("com.sun.ts.tests.common.vehicle.ejbembed");

    public Status run(String[] args, Properties props) {
        int statusCode = Status.NOT_RUN;
        String passOrFail = null;
        String reason = null;
        EJBLiteClientIF client = null;
        
        try {
            client = createClient(args, props);
            passOrFail = client.getStatus();
            reason = client.getReason();

            if (passOrFail.startsWith(TEST_PASSED)) {
                statusCode = Status.PASSED;
            } else {
                statusCode = Status.FAILED;
            }

        } catch (Exception e) {
            statusCode = Status.FAILED;
            reason = TestUtil.printStackTraceToString(e);
        } finally {
            if(client != null) {
                client.getContainer().close();
            }
        }
        return new ReasonableStatus(statusCode, reason);
    }
    
    private File[] parseAdditionalModules(String[] args) {
        if(args == null) {
            return null;
        }
        List<String> mods = new ArrayList<String>();
        for(int i = 0; i < args.length; i++) {
            if(EJBLiteClientIF.ADDITIONAL_MODULES_KEY.equals(args[i])) {
                mods.add(args[++i]);
            }
        }
        File[] files = new File[mods.size()];
        for(int i = 0; i < mods.size(); i++) {
            files[i] = new File(mods.get(i));
        }
        return files;
    }

    private EJBLiteClientIF createClient(String[] args, Properties props) throws Exception {
        Class<?> c = Class.forName(props.getProperty("test_classname"));
        EJBLiteClientIF client = (EJBLiteClientIF) c.newInstance();

        client.setAdditionalModules(parseAdditionalModules(args));
        client.setTestName(props.getProperty("testName"));
        client.setInjectionSupported(false);
        client.setModuleName(EJBLiteClientIF.EJBEMBED_JAR_NAME_BASE);
        client.setContextClassLoader();

        Map<String, Object> containerInitProps = client.getContainerInitProperties();
        EJBContainer container = (containerInitProps == null ? EJBContainer.createEJBContainer()
                : EJBContainer.createEJBContainer(containerInitProps));
        javax.naming.Context context = container.getContext();

        client.setContainer(container);
        client.setContext(context);

        InjectionResolver injectionResolver = new InjectionResolver(client, container);
        injectionResolver.resolve();

        return client;
    }
}
