/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: XMLAsyncHandler.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.api.javax_xml_ws.AsyncHandler;

import com.sun.ts.lib.util.*;

import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.transform.Source;

public class XMLAsyncHandler implements AsyncHandler<Source> 
{
	private boolean dataReady = false;
	private Source theData;
	private java.util.Map<String,Object> theContext;

	public XMLAsyncHandler(){
	    TestUtil.logMsg("in XMLAsyncHandler");
	}
	public synchronized boolean isDataReady() { return dataReady; }
	public Source getData() { return theData; }
	public java.util.Map<String,Object> getContext() { return theContext; }

	public void handleResponse(Response<Source> res) {
	    TestUtil.logMsg("in XMLAsyncHandler.handleResponse()");
	    try {
		theData = res.get();
		theContext = res.getContext();
	    }
	    catch (Exception e) {
		e.printStackTrace();
	    }
	    synchronized (this) {
		dataReady = true;
	    }
	}
}
