/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HelloImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.sharedwebservices.doclithelloservice;

import javax.xml.ws.WebServiceException;

import javax.jws.WebService;

@WebService(
    portName="HelloPort",
    serviceName="HelloService",
    targetNamespace="http://helloservice.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/WSDLHelloService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.sharedwebservices.doclithelloservice.Hello"
)

public class HelloImpl implements Hello {
    private static final ObjectFactory of = new ObjectFactory();

    public HelloResponse hello(HelloRequest req) {
        System.out.println("HelloImpl received: " + req.getArgument());
        HelloResponse resp = null;
        resp = of.createHelloResponse();
        resp.setArgument(req.getArgument());
        return resp;
    }

    public void helloOneWay(HelloOneWayRequest req) {
        System.out.println("HelloImpl received: " + req.getArgument());
    }
}
