/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: GetTrackerDataImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.sharedwebservices.rlhandlerservice;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import java.util.Properties;
import com.sun.ts.tests.jaxws.common.*;

import javax.xml.ws.*;
import javax.xml.ws.handler.*;
import javax.xml.ws.handler.soap.*;

import javax.xml.ws.WebServiceException;

import javax.jws.WebService;

@WebService(
    portName="GetTrackerDataPort",
    targetNamespace="http://rlhandlerservice.org/wsdl",
    serviceName="RLHandlerService",
    wsdlLocation="WEB-INF/wsdl/RLHandlerService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.sharedwebservices.rlhandlerservice.GetTrackerData"
)

public class GetTrackerDataImpl implements GetTrackerData {
    public GetTrackerDataResult getTrackerData(GetTrackerDataAction action)  {

     Handler_Util.setTraceFlag(action.getHarnesslogtraceflag());

     Handler_Util.initTestUtil("GetTrackerDataImpl",
                               action.getHarnessloghost(),
                               action.getHarnesslogport(), 
                               action.getHarnesslogtraceflag());

     TestUtil.logTrace("*** in GetTrackerDataImpl ***");
	String[] messages = null;

     String theAction = action.getAction();
     TestUtil.logTrace("*** action = "+theAction+" ***");


     if (theAction.equals("getArrayMessages1")) {
	     messages = HandlerTracker.getArrayMessages1();
     } else if (theAction.equals("getArrayMessages2")) {
	     messages = HandlerTracker.getArrayMessages2();
     } else if (theAction.equals("getArrayMessages3")) {
	     messages = HandlerTracker.getArrayMessages3();
     } else if (theAction.equals("getArrayMessages4")) {
	     messages = HandlerTracker.getArrayMessages4();
     } else if (theAction.equals("getArrayThrowables")) {
	     messages = HandlerTracker.getArrayThrowables();
     } else if (theAction.equals("purge")) {
	     HandlerTracker.purge();
          String m[] = {"purge complete"};
          messages=m;
     } else {
          String[] m = {"Did not get one of the excepted GetTrackerData action messages, the action message received was:"+theAction};
          messages = m;
     }

     GetTrackerDataResult r = null;
     try {
         TestUtil.logTrace("The endpoint is sending back the following data:");
         TestUtil.logTrace("action="+action.getAction());
         TestUtil.logTrace("harnessloghost="+action.getHarnessloghost());
         TestUtil.logTrace("harnesslogport="+action.getHarnesslogport());
         TestUtil.logTrace("harnesslogtraceflag="+action.getHarnesslogtraceflag());

         r = new GetTrackerDataResult();
         for (int i=0;i<messages.length;i++){
             r.getResult().add(messages[i]);
             TestUtil.logTrace("message["+i+"]="+messages[i]);
         }

         r.setHarnessloghost(action.getHarnessloghost());
         r.setHarnesslogport(action.getHarnesslogport());
         r.setHarnesslogtraceflag(action.getHarnesslogtraceflag());
     } catch (Exception e) {
         throw new WebServiceException(e.getMessage(), e);
     }
     return r;
  }
}
