/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.j2w.rpc.literal.R2005;

import java.util.Properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxws.sharedclients.rpclitclient.*;
import com.sun.ts.tests.jaxws.wsi.constants.DescriptionConstants;
import com.sun.ts.tests.jaxws.wsi.utils.DescriptionUtils;
import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest implements DescriptionConstants {
    /**
     * The client.
     */
    private SOAPClient client;

    
    static J2WRLShared service = null;
    
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = ClientFactory.getClient(J2WRLSharedClient.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testImportedNamespaces
     *
     * @assertion_ids: WSI:SPEC:R2005
     *
     * @test_Strategy: Retrieve the WSDL, generated by the Java-to-WSDL tool,
     * and examine all wsdl:import elements, ensuring that the target namespace
     * of the imported WSDL matches the namespace of the wsdl:import. 
     * 
     * @throws Fault
     */
    public void testImportedNamespaces() throws Fault {
        Document document = client.getDocument();
        Element[] imports = DescriptionUtils.getImports(document);
        for (int i = 0; i < imports.length; i++) {
            verifyImport(imports[i]);
        }
    }
    
    protected void verifyImport(Element element) throws Fault {
        String location = element.getAttribute(WSDL_LOCATION_ATTR);
        String namespace = element.getAttribute(WSDL_NAMESPACE_ATTR);
        Document document = DescriptionUtils.getDocumentFromLocation(location);
        if (!DescriptionUtils.isDescription(document)) {
            throw new Fault("Document imported from '" + location + "' is not a description (BP-R2005)");
        }
        String targetNamespace = document.getDocumentElement().getAttribute(WSDL_TARGETNAMESPACE_ATTR);
        if (!namespace.equals(targetNamespace)) {
            throw new Fault("Target namespace '" + targetNamespace + "' of description at '" + location + "' does not match specified namespace '" + namespace + "' on wsdl:import (BP-R2005)");
        }
    }
}
