/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62877 2011-05-26 12:26:55Z adf $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.j2w.rpc.literal.R2754;

import com.sun.ts.lib.util.*;
import java.util.Properties;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxws.sharedclients.faultclient.*;
import com.sun.ts.tests.jaxws.wsi.constants.DescriptionConstants;
import com.sun.ts.tests.jaxws.wsi.constants.SOAPConstants;
import com.sun.ts.tests.jaxws.wsi.utils.DescriptionUtils;

import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest implements DescriptionConstants, SOAPConstants {
    /**
     * The client.
     */
    private SOAPClient client;
   
    
    static FaultTest service = null;

    private boolean foundOne=false; 
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client test = new Client();
        Status status = test.run(args, System.out, System.err);
        status.exit();
    }


    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = ClientFactory.getClient(FaultTestClient.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testNameAttributes
     *
     * @assertion_ids: WSI:SPEC:R2754
     *
     * @test_Strategy: Retrieve the WSDL, generated by the Java-to-WSDL tool,
     * and examine the wsdl:binding elements, ensuring that the contained soap:fault
     * elements have the same name attribute specified on its parent.
     *
     * @throws Fault
     */
    public void testNameAttributes() throws Fault {
        Document document = client.getDocument();
        Element[] bindings = DescriptionUtils.getBindings(document);
        logTrace("in testNameAttributes, bindings.length="+bindings.length);
        for (int i = 0; i < bindings.length; i++) {
            logTrace("bindings["+i+"].getAttribute(name) = "+bindings[i].getAttribute("name"));
            getOperations(bindings[i]);
        }
        if (!foundOne) {
            throw new Fault("No soap:fault elements found during test");
        }
 
    }
    
    protected void getOperations(Element binding) throws Fault {
        Element[] operations = DescriptionUtils.getChildElements(binding, WSDL_NAMESPACE_URI, WSDL_OPERATION_LOCAL_NAME);
        logTrace("in getBinding, operations.length="+operations.length);
        for (int i = 0; i < operations.length; i++) {
            logTrace("operations["+i+"].getAttribute(name)="+operations[i].getAttribute("name"));
            getWSDLFaults(operations[i]);
        }
    }
    
    protected void getWSDLFaults(Element operation) throws Fault {
        Element[] list = DescriptionUtils.getChildElements(operation, WSDL_NAMESPACE_URI, WSDL_FAULT_LOCAL_NAME);
        for (int i = 0; i < list.length; i++) {
            logTrace("in getWSDLFaults - list["+i+"].getAttribute(name) = "+list[i].getAttribute("name"));
            String WSDLFaultName = getWSDLFaultName(list[i]);
            getSOAPFaults(WSDLFaultName, list[i]);
        }
    }
    protected void getSOAPFaults(String WSDLFaultName, Element WSDLFaults) throws Fault {
        Element[] list = DescriptionUtils.getChildElements(WSDLFaults, SOAP_NAMESPACE_URI, SOAP_FAULT_LOCAL_NAME);
        for (int i = 0; i < list.length; i++) {
            logTrace("in getSOAPFaults - list["+i+"].getAttribute(name) = "+list[i].getAttribute("name"));
            String SOAPFaultName = getSOAPFaultName(list[i]);
            if (!(SOAPFaultName.equals(WSDLFaultName))){
                throw new Fault("Required 'name' attribute does not match the value of the name attribute on its parent element (BP-R2754) - wsdl:fault="+WSDLFaultName+", soap:fault="+SOAPFaultName);
            }
        }
    }
    
    protected String getWSDLFaultName(Element fault) throws Fault {
        Attr attr = fault.getAttributeNode(WSDL_NAME_ATTR);
        if (attr == null) {
            throw new Fault("Required 'name' attribute not present on wsdl:fault element (BP-R2754)");
        }
        String name = attr.getValue();
        logTrace("name="+name);
        return(name);
    }

    protected String getSOAPFaultName(Element fault) throws Fault {
        Attr attr = fault.getAttributeNode(SOAP_NAME_ATTR);
        if (attr == null) {
            throw new Fault("Required 'name' attribute not present on soap:fault element (BP-R2754)");
        } else {
            foundOne=true;
        }
        String name = attr.getValue();
        logTrace("name="+name);
        return(name);
    }

}
