/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR2748ClientOne.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2748;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JRLR2748ClientOne extends SOAPClient {
    public W2JRLR2748ClientOne(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this(webServerHost, webServerPort, mode, null);
    }

    public W2JRLR2748ClientOne(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jrlr2748testservice.org/W2JRLR2748TestService.wsdl");
        stubContext.setService("W2JRLR2748TestService");
        stubContext.setPort("W2JRLR2748TestOnePort");
        stubContext.setEndpointInterface(W2JRLR2748TestOne.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr2748.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr2748.wsdlloc.1";
    }

    public String echoString(String str) throws Exception {
        NonNullString nns = new NonNullString();
	nns.setP1(str);
        nns = ((W2JRLR2748TestOne)stubContext.getStub()).echoString(nns);
        return nns.getP1();
    }
}
