/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.SerialPortConnection;
import java.io.IOException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;

public class SerialPortConnectionFactory
implements ConnectionFactory {
    private CommPortIdentifier portId;
    private String app;
    private int timeout;

    public SerialPortConnectionFactory(String name, String app, int timeout) throws NoSuchPortException {
        this(CommPortIdentifier.getPortIdentifier((String)name), app, timeout);
    }

    public SerialPortConnectionFactory(CommPortIdentifier portId, String app, int timeout) {
        if (portId.getPortType() != 1) {
            throw new IllegalArgumentException("Not a serial port: " + portId.getName());
        }
        this.portId = portId;
        this.app = app;
        this.timeout = timeout;
    }

    public synchronized Connection nextConnection() throws ConnectionFactory.Fault {
        try {
            SerialPortConnection c = new SerialPortConnection(this.portId, this.app, this.timeout);
            return c;
        }
        catch (InterruptedException e) {
            System.err.println("Error connection: " + e);
            throw new ConnectionFactory.Fault(e, true);
        }
        catch (IOException e) {
            System.err.println("Error connection: " + e);
            throw new ConnectionFactory.Fault(e, true);
        }
        catch (PortInUseException e) {
            System.err.println("Error connection: " + (Object)((Object)e));
            throw new ConnectionFactory.Fault((Exception)((Object)e), false);
        }
    }

    public void close() {
    }
}

