/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.ResourceLoader;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

class ManagerLoader {
    private Class managerClass;
    private Constructor constr;
    private Class[] constrArgTypes;
    private Object[] constrArgs;
    private PrintStream log;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ManagerLoader.class);

    ManagerLoader(Class managerClass, PrintStream log) {
        this.setManagerClass(managerClass);
        this.setLog(log);
    }

    void setManagerClass(Class managerClass) {
        this.managerClass = managerClass;
    }

    void setManagerConstructorArgs(Class[] argTypes, Object[] args) {
        this.constrArgTypes = argTypes;
        this.constrArgs = args;
    }

    void setLog(PrintStream log) {
        this.log = log;
    }

    Set loadManagers(String resourceName) throws IOException {
        Enumeration e = ResourceLoader.getResources(resourceName, this.getClass());
        HashSet<Object> mgrs = new HashSet<Object>();
        while (e.hasMoreElements()) {
            URL entry = (URL)e.nextElement();
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(entry.openStream()));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    try {
                        Class<?> c = Class.forName(line);
                        Object mgr = this.newInstance(c);
                        if (this.managerClass.isInstance(mgr)) {
                            mgrs.add(mgr);
                            continue;
                        }
                        if (this.log == null) continue;
                        this.writeI18N("ml.notSubtype", new Object[]{line, this.managerClass.getName(), entry});
                    }
                    catch (ClassNotFoundException ex) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantFindClass", new Object[]{line, entry});
                    }
                    catch (IllegalAccessException ex) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantAccessClass", new Object[]{line, entry});
                    }
                    catch (InstantiationException ex) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantCreateClass", new Object[]{line, entry});
                    }
                    catch (NoSuchMethodException ex) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantFindConstr", new Object[]{line, entry});
                    }
                }
                in.close();
            }
            catch (IOException ex) {
                if (this.log == null) continue;
                this.writeI18N("ml.cantRead", new Object[]{entry, ex});
            }
        }
        return mgrs;
    }

    private Object newInstance(Class c) throws IllegalAccessException, InstantiationException, NoSuchMethodException {
        if (this.constrArgTypes == null || this.constrArgTypes.length == 0) {
            return c.newInstance();
        }
        try {
            Constructor constr = c.getConstructor(this.constrArgTypes);
            return constr.newInstance(this.constrArgs);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(e);
        }
    }

    private void writeI18N(String key, Object[] args) {
        this.log.println(i18n.getString(key, args));
    }
}

