/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class DirectoryClassLoader
extends ClassLoader {
    private File loadDir;
    private Hashtable classes = new Hashtable();

    public DirectoryClassLoader(File dir) {
        this.loadDir = dir;
    }

    public DirectoryClassLoader(String dirName) {
        this.loadDir = new File(dirName);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class cl = (Class)this.classes.get(name);
        if (cl == null) {
            try {
                cl = this.findSystemClass(name);
            }
            catch (ClassNotFoundException e) {
                cl = this.locateClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public URL getResource(String name) {
        URL url = ClassLoader.getSystemResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    public URL findResource(String name) {
        try {
            File f = new File(this.loadDir, name);
            if (f.exists()) {
                return new URL("file:" + f.getAbsolutePath());
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private synchronized Class locateClass(String name) throws ClassNotFoundException {
        Class<?> cl = (Class<?>)this.classes.get(name);
        if (cl != null) {
            return cl;
        }
        String cname = name.replace('.', '/') + ".class";
        File file = new File(this.loadDir, cname);
        try {
            void var6_9;
            FileInputStream in = new FileInputStream(file);
            try {
                int len = ((InputStream)in).available();
                byte[] data = new byte[len];
                for (int total = 0; total < data.length; total += ((InputStream)in).read(data, total, data.length - total)) {
                }
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            cl = this.defineClass(name, (byte[])var6_9, 0, ((void)var6_9).length);
            this.classes.put(name, cl);
            return cl;
        }
        catch (FileNotFoundException e) {
            throw new ClassNotFoundException(name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
    }
}

