
drop table ADDRESS cascade constraints !
CREATE TABLE ADDRESS (id VARCHAR2(255) PRIMARY KEY, street VARCHAR2(255), city VARCHAR2(255), state VARCHAR2(255), zip VARCHAR2(255)) !

drop table PHONE_TABLE cascade constraints !
CREATE TABLE PHONE_TABLE (id VARCHAR2(255) PRIMARY KEY, area VARCHAR2(255), phone_number VARCHAR2(255), FK_FOR_ADDRESS VARCHAR2(255)) !

drop table CUSTOMER_TABLE cascade constraints !
CREATE TABLE CUSTOMER_TABLE (id VARCHAR2(255) PRIMARY KEY, name VARCHAR2(255) , country VARCHAR2(255), code VARCHAR2(255), FK5_FOR_CUSTOMER_TABLE VARCHAR2(255), FK6_FOR_CUSTOMER_TABLE VARCHAR2(255)) !

ALTER TABLE PHONES DROP CONSTRAINT FK_FOR_PHONES !
ALTER TABLE EMPLOYEES DROP CONSTRAINT FK_FOR_EMPLOYEES !

DROP TABLE CUST_TABLE !
CREATE TABLE CUST_TABLE ( CUST_ID VARCHAR(255) PRIMARY KEY NOT NULL, NAME VARCHAR(255), COUNTRY VARCHAR(255), CODE VARCHAR(255)) !

DROP TABLE PHONES !
CREATE TABLE PHONES (ID VARCHAR(255), PHONE_NUMBER VARCHAR(255), FK_FOR_PHONES VARCHAR(255)) !
ALTER TABLE PHONES ADD CONSTRAINT FK_FOR_PHONES FOREIGN KEY (FK_FOR_PHONES) REFERENCES CUST_TABLE(CUST_ID) !

DROP TABLE EMPLOYEES !
CREATE TABLE EMPLOYEES (ID VARCHAR(255), LASTNAMEEMPLOYEES VARCHAR(255), FK_FOR_EMPLOYEES VARCHAR(255)) !
ALTER TABLE EMPLOYEES ADD CONSTRAINT FK_FOR_EMPLOYEES FOREIGN KEY (FK_FOR_EMPLOYEES) REFERENCES CUST_TABLE (CUST_ID) !

DROP TABLE TRIM_TABLE !
CREATE TABLE TRIM_TABLE (ID VARCHAR2(255) PRIMARY KEY NOT NULL, name CHAR(30) NOT NULL)!

DROP TABLE ALIAS_TABLE cascade constraints !
CREATE TABLE ALIAS_TABLE ( ID VARCHAR(255)  PRIMARY KEY, ALIAS VARCHAR(255) , FK1_FOR_CUSTOMER_TABLE VARCHAR(255) , FK2_FOR_CUSTOMER_TABLE VARCHAR(255) ) !

drop table FKS_ALIAS_CUSTOMER cascade constraints !
CREATE TABLE FKS_ALIAS_CUSTOMER ( FK_FOR_CUSTOMER_TABLE VARCHAR2(255) , FK_FOR_ALIAS_TABLE VARCHAR2(255)) !

DROP table FKS_ANOOP_CNOOP cascade constraints!
CREATE TABLE FKS_ANOOP_CNOOP( FK8_FOR_CUSTOMER_TABLE VARCHAR(255) , FK2_FOR_ALIAS_TABLE VARCHAR2(255))!

drop table CREDITCARD_TABLE cascade constraints !
CREATE TABLE CREDITCARD_TABLE (id VARCHAR(255) PRIMARY KEY, type VARCHAR(255), expires VARCHAR(255), approved NUMBER, creditcard_number VARCHAR(255), balance DOUBLE PRECISION, FK3_FOR_CUSTOMER_TABLE VARCHAR(255), FK_FOR_ORDER_TABLE VARCHAR(255) ) !

drop table ORDER_TABLE cascade constraints !
CREATE TABLE  ORDER_TABLE (id VARCHAR2(255) PRIMARY KEY, totalPrice DOUBLE PRECISION , FK4_FOR_CUSTOMER_TABLE VARCHAR2(255), FK0_FOR_LINEITEM_TABLE VARCHAR2(255)) !
 
DROP TABLE PRODUCT_DETAILS !
CREATE TABLE PRODUCT_DETAILS ( ID VARCHAR(255)  PRIMARY KEY NOT NULL, WHOUSE VARCHAR(255) , LICENSE_KEY integer) !

drop table PRODUCT_TABLE cascade constraints !
CREATE TABLE PRODUCT_TABLE (id VARCHAR2(255) PRIMARY KEY, NAME VARCHAR2(255), PRICE DOUBLE PRECISION, QUANTITY NUMBER, PNUM NUMBER, PRODUCT_TYPE VARCHAR(255), INCEPTION DATE NULL, SOLD DATE NULL, MODEL NUMBER, REV DOUBLE PRECISION ) !

DROP TABLE PRODUCT_TABLE_DISCRIMINATOR cascade constraints !
CREATE TABLE PRODUCT_TABLE_DISCRIMINATOR ( id VARCHAR2(255) PRIMARY KEY, NAME VARCHAR2(255), QUANTITY NUMBER, PNUM NUMBER, PRICE DOUBLE PRECISION, PRODUCT_TYPE NUMBER) !

DROP TABLE PRICED_PRODUCT_TABLE !
CREATE TABLE PRICED_PRODUCT_TABLE (ID VARCHAR(255) PRIMARY KEY NOT NULL, NAME VARCHAR(255), PRICE DOUBLE PRECISION , QUANTITY NUMBER, PNUM NUMBER ) !

DROP table SPOUSE_TABLE cascade constraints!
CREATE TABLE SPOUSE_TABLE (ID VARCHAR(255) PRIMARY KEY,  FIRSTNAME VARCHAR(255), MAIDENNAME VARCHAR(255), LASTNAME VARCHAR(255), SOCSECNUM VARCHAR(255), FK7_FOR_CUSTOMER_TABLE VARCHAR(255), FK_FOR_INFO_TABLE VARCHAR(255) )!

DROP table INFO_TABLE cascade constraints!
CREATE TABLE INFO_TABLE (ID VARCHAR(255) PRIMARY KEY, INFOSTREET VARCHAR(255), INFOCITY VARCHAR(255), INFOSTATE VARCHAR(255), INFOZIP VARCHAR2(255), FK_FOR_SPOUSE_TABLE VARCHAR2(255) )!

drop table LINEITEM_TABLE cascade constraints !
CREATE TABLE LINEITEM_TABLE (id VARCHAR2(255) PRIMARY KEY, quantity NUMBER, FK_FOR_PRODUCT_TABLE VARCHAR2(255), FK1_FOR_ORDER_TABLE VARCHAR2(255)) !

ALTER TABLE ALIAS_TABLE ADD CONSTRAINT FK1_FOR_CUSTOMER FOREIGN KEY (FK1_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) !

ALTER TABLE ALIAS_TABLE ADD CONSTRAINT FK2_FOR_CUSTOMER FOREIGN KEY (FK2_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) !

ALTER TABLE FKS_ALIAS_CUSTOMER ADD CONSTRAINT FK_FOR_CUSTOMER FOREIGN KEY (FK_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) !

ALTER TABLE FKS_ALIAS_CUSTOMER ADD CONSTRAINT FK_FOR_ALIAS FOREIGN KEY (FK_FOR_ALIAS_TABLE) REFERENCES ALIAS_TABLE (ID) !

ALTER TABLE FKS_ANOOP_CNOOP  add constraint FK2_ALIAS Foreign Key (FK2_FOR_ALIAS_TABLE) references ALIAS_TABLE(id) !

ALTER TABLE FKS_ANOOP_CNOOP  add constraint FK8_CUSTOMER Foreign Key (FK8_FOR_CUSTOMER_TABLE) references CUSTOMER_TABLE(id) !

ALTER TABLE CREDITCARD_TABLE add ( constraint FK3_FOR_CUSTOMER_TABLE Foreign Key (FK3_FOR_CUSTOMER_TABLE) references CUSTOMER_TABLE(id)  ) !

ALTER TABLE CREDITCARD_TABLE add ( constraint FK_FOR_ORDER_TABLE Foreign Key (FK_FOR_ORDER_TABLE) references ORDER_TABLE(id)  ) !
       
ALTER TABLE ORDER_TABLE add ( constraint FK4_FOR_CUSTOMER_TABLE Foreign Key (FK4_FOR_CUSTOMER_TABLE) references CUSTOMER_TABLE(id)  ) !

ALTER TABLE ORDER_TABLE add ( constraint FK0_FOR_LINEITEM_TABLE Foreign Key (FK0_FOR_LINEITEM_TABLE) references LINEITEM_TABLE(id)  ) !

ALTER TABLE LINEITEM_TABLE add ( constraint FK_FOR_PRODUCT_TABLE Foreign Key (FK_FOR_PRODUCT_TABLE) references PRODUCT_TABLE(id)  ) !

ALTER TABLE LINEITEM_TABLE add ( constraint FK1_FOR_ORDER_TABLE Foreign Key (FK1_FOR_ORDER_TABLE) references ORDER_TABLE(id)  ) !
 
ALTER TABLE SPOUSE_TABLE add (constraint FK7_FOR_CUSTOMER_TABLE Foreign Key(FK7_FOR_CUSTOMER_TABLE) references CUSTOMER_TABLE(ID) ) ! 

ALTER TABLE SPOUSE_TABLE add (constraint FK_FOR_INFO_TABLE Foreign Key (FK_FOR_INFO_TABLE) references INFO_TABLE(ID) ) !

ALTER TABLE INFO_TABLE add (constraint FK_FOR_SPOUSE_TABLE Foreign Key (FK_FOR_SPOUSE_TABLE) references SPOUSE_TABLE(ID) ) !

ALTER TABLE CUSTOMER_TABLE add (constraint FK5_FOR_CUSTOMER_TABLE Foreign Key (FK5_FOR_CUSTOMER_TABLE) references ADDRESS(ID) ) !

ALTER TABLE CUSTOMER_TABLE add (constraint FK6_FOR_CUSTOMER_TABLE Foreign Key (FK6_FOR_CUSTOMER_TABLE) references ADDRESS(ID) ) !

ALTER TABLE PHONE_TABLE add ( constraint FK_FOR_ADDRESS Foreign Key (FK_FOR_ADDRESS) references ADDRESS(ID)  ) !

DROP TABLE EMPLOYEE CASCADE CONSTRAINTS !
CREATE TABLE EMPLOYEE (ID NUMBER NOT NULL, FIRSTNAME VARCHAR(255) NULL, LASTNAME VARCHAR(255) NULL, HIREDATE DATE NULL, SALARY REAL NOT NULL, STATUS VARCHAR(255), THEORDERCOLUMN NUMBER, EMPLOYEES_ORDER NUMBER, FK_MGR NUMBER NULL, FK_DEPT NUMBER NULL, FK_PROJECT NUMBER NULL, FK_INS NUMBER NULL, CONSTRAINT PK_EMPLOYEE PRIMARY KEY (ID)) !


DROP TABLE DEPARTMENT CASCADE CONSTRAINTS !
CREATE TABLE DEPARTMENT (NAME VARCHAR(255) NULL, ID NUMBER NOT NULL,  COMPANY_COMPANYID NUMBER, CONSTRAINT PK_DEPARTMENT PRIMARY KEY (ID)) !

DROP TABLE EMP_MAPKEYCOL2 CASCADE CONSTRAINTS !
DROP TABLE DEPARTMENT2 !
CREATE TABLE DEPARTMENT2 (ID NUMBER NOT NULL, NAME VARCHAR(255), CONSTRAINT PK_DEPARTMENT2 PRIMARY KEY (ID)) !

DROP TABLE COFFEE !
CREATE TABLE COFFEE (ID NUMBER NOT NULL, BRANDNAME VARCHAR(25), PRICE REAL, CONSTRAINT PK_COFFEE PRIMARY KEY (ID)) !

DROP TABLE COMPANY CASCADE CONSTRAINTS !
CREATE TABLE COMPANY (COMPANYID NUMBER NOT NULL, NAME VARCHAR(25), ADDRESS_ID VARCHAR(255), CONSTRAINT PK_COMPANY PRIMARY KEY (COMPANYID)) !
 
DROP TABLE TEAM CASCADE CONSTRAINTS !
CREATE TABLE TEAM (NAME VARCHAR(255) NULL, TEAMID NUMBER NOT NULL,  COMPANY_COMPANYID NUMBER, CONSTRAINT PK_TEAM PRIMARY KEY (TEAMID)) !

ALTER TABLE COMPANY ADD CONSTRAINT FK_ADDRESS FOREIGN KEY (ADDRESS_ID) REFERENCES ADDRESS (ID) !
ALTER TABLE DEPARTMENT ADD CONSTRAINT FK_COMPANY FOREIGN KEY (COMPANY_COMPANYID) REFERENCES COMPANY (COMPANYID) !
 
ALTER TABLE TEAM ADD CONSTRAINT COMPANY_COMPANYID FOREIGN KEY (COMPANY_COMPANYID) REFERENCES COMPANY(COMPANYID) !

DROP TABLE PROJECT CASCADE CONSTRAINTS!
CREATE TABLE PROJECT (PROJID NUMBER NOT NULL, NAME VARCHAR(25), BUDGET NUMBER, CONSTRAINT PK_PROJECT PRIMARY KEY  (PROJID)) !
 
DROP TABLE INSURANCE CASCADE CONSTRAINTS !
CREATE TABLE INSURANCE (INSID NUMBER NOT NULL, CARRIER VARCHAR(255) , CONSTRAINT PK_INSURANCE PRIMARY KEY (INSID)) !
 
DROP TABLE ANNUALREVIEW CASCADE CONSTRAINTS !
CREATE TABLE ANNUALREVIEW (AID NUMBER NOT NULL, SERVICE NUMBER, CONSTRAINT PK_ANNUAL PRIMARY KEY (AID)) !

DROP TABLE PERSON CASCADE CONSTRAINTS !
CREATE TABLE PERSON (PERSONID NUMBER NOT NULL, FIRSTNAME VARCHAR(255) NULL, LASTNAME VARCHAR(255) NULL, PROJECT_PROJID NUMBER NULL, INSURANCE_INSID NUMBER NULL, TEAM_TEAMID NUMBER NULL, CONSTRAINT PK_PERSON PRIMARY KEY (PERSONID)) !

DROP TABLE PROJECT_PERSON CASCADE CONSTRAINTS !
CREATE TABLE PROJECT_PERSON (PROJECTS_PROJID NUMBER , PERSONS_PERSONID NUMBER ) !

DROP TABLE PERSON_ANNUALREVIEW CASCADE CONSTRAINTS !
CREATE TABLE PERSON_ANNUALREVIEW (PERSON_PERSONID NUMBER, ANNUALREVIEWS_AID NUMBER) !
 
DROP TABLE PERSON_INSURANCE CASCADE CONSTRAINTS !
CREATE TABLE PERSON_INSURANCE (PERSON_PERSONID NUMBER, INSURANCE_INSID NUMBER ) !

ALTER TABLE EMPLOYEE ADD ( CONSTRAINT FK_DEPT FOREIGN KEY (FK_DEPT) REFERENCES DEPARTMENT(ID)  )!
ALTER TABLE EMPLOYEE ADD ( CONSTRAINT FK_PROJECT FOREIGN KEY (FK_PROJECT) REFERENCES PROJECT(PROJID)  )!
ALTER TABLE EMPLOYEE ADD ( CONSTRAINT FK_INS FOREIGN KEY (FK_INS) REFERENCES INSURANCE(INSID)  )!

ALTER TABLE PERSON ADD ( CONSTRAINT TEAM_TEAMID FOREIGN KEY (TEAM_TEAMID) REFERENCES TEAM(TEAMID)  )!

ALTER TABLE PERSON ADD ( CONSTRAINT PROJECT_PROJID FOREIGN KEY (PROJECT_PROJID) REFERENCES PROJECT(PROJID)  )!

ALTER TABLE PROJECT_PERSON ADD (CONSTRAINT P_PROJID Foreign Key (PROJECTS_PROJID) references PROJECT(PROJID)  )!

ALTER TABLE PROJECT_PERSON ADD (CONSTRAINT PERSONS_PERSONID Foreign Key (PERSONS_PERSONID) references PERSON(PERSONID) )!


ALTER TABLE PERSON_ANNUALREVIEW ADD (CONSTRAINT ANNUALREVIEWS_AID Foreign Key (ANNUALREVIEWS_AID) references ANNUALREVIEW(AID)  ) !

ALTER TABLE PERSON_ANNUALREVIEW ADD (CONSTRAINT PERSON_PERSONID Foreign Key (PERSON_PERSONID) references PERSON(PERSONID)) !

ALTER TABLE PERSON_INSURANCE ADD (CONSTRAINT P_PERSONID Foreign Key (PERSON_PERSONID) references PERSON(PERSONID) )!

ALTER TABLE PERSON_INSURANCE  ADD (CONSTRAINT INS_INSID Foreign Key (INSURANCE_INSID) references INSURANCE(INSID)) !

DROP TABLE PURCHASE_ORDER !
CREATE TABLE PURCHASE_ORDER (ID NUMBER NOT NULL, TOTAL NUMBER, DESCRIPTION VARCHAR2(50), CONSTRAINT PURCHASE_ORDER PRIMARY KEY (ID)) !

drop table BEANEJB_1X1_BI_BTOB cascade constraints !
CREATE TABLE BEANEJB_1X1_BI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_1X1_BI_BTOB VARCHAR(255), FK2_FOR_AEJB_1X1_BI_BTOB VARCHAR(255), FK1_FOR_BEJB_1X1_BI_BTOB VARCHAR(255), FK2_FOR_BEJB_1X1_BI_BTOB VARCHAR(255)) !

drop table AEJB_1X1_BI_BTOB cascade constraints !
CREATE TABLE  AEJB_1X1_BI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_1X1_BI_BTOB cascade constraints !
CREATE TABLE BEJB_1X1_BI_BTOB ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_1X1_BI_BTOB VARCHAR(255)) !

ALTER TABLE BEANEJB_1X1_BI_BTOB add ( constraint FK1_FOR_AEJB_1X1_BI_BTOB Foreign Key (FK1_FOR_AEJB_1X1_BI_BTOB) references AEJB_1X1_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_1X1_BI_BTOB add ( constraint FK2_FOR_AEJB_1X1_BI_BTOB Foreign Key (FK2_FOR_AEJB_1X1_BI_BTOB) references AEJB_1X1_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_1X1_BI_BTOB add ( constraint FK1_FOR_BEJB_1X1_BI_BTOB Foreign Key (FK1_FOR_BEJB_1X1_BI_BTOB) references BEJB_1X1_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_1X1_BI_BTOB add ( constraint FK2_FOR_BEJB_1X1_BI_BTOB Foreign Key (FK2_FOR_BEJB_1X1_BI_BTOB) references BEJB_1X1_BI_BTOB(id) ) !

ALTER TABLE BEJB_1X1_BI_BTOB add ( constraint FK_FOR_AEJB_1X1_BI_BTOB Foreign Key (FK_FOR_AEJB_1X1_BI_BTOB) references AEJB_1X1_BI_BTOB(id) ) !

drop table BEANEJB_1X1_BI_CASCADE cascade constraints !
CREATE TABLE BEANEJB_1X1_BI_CASCADE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_1X1_BI_CASCADE VARCHAR(255), FK2_FOR_AEJB_1X1_BI_CASCADE VARCHAR(255), FK1_FOR_BEJB_1X1_BI_CASCADE VARCHAR(255), FK2_FOR_BEJB_1X1_BI_CASCADE VARCHAR(255)) !

drop table AEJB_1X1_BI_CASCADE cascade constraints !
CREATE TABLE  AEJB_1X1_BI_CASCADE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_1X1_BI_CASCADE cascade constraints !
CREATE TABLE BEJB_1X1_BI_CASCADE ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_1X1_BI_CASCADE VARCHAR(255)) !

ALTER TABLE BEANEJB_1X1_BI_CASCADE add ( constraint FK1_FOR_AEJB_1X1_BI_CASCADE Foreign Key (FK1_FOR_AEJB_1X1_BI_CASCADE) references AEJB_1X1_BI_CASCADE(id)) !

ALTER TABLE BEANEJB_1X1_BI_CASCADE add ( constraint FK2_FOR_AEJB_1X1_BI_CASCADE Foreign Key (FK2_FOR_AEJB_1X1_BI_CASCADE) references AEJB_1X1_BI_CASCADE(id)) !

ALTER TABLE BEJB_1X1_BI_CASCADE add ( constraint FK_FOR_AEJB_1X1_BI_CASCADE Foreign Key (FK_FOR_AEJB_1X1_BI_CASCADE) references AEJB_1X1_BI_CASCADE(id)) !

drop table BEANEJB_1X1_UNI_BTOB cascade constraints !
CREATE TABLE BEANEJB_1X1_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_1X1_UNI_BTOB VARCHAR(255), FK2_FOR_AEJB_1X1_UNI_BTOB VARCHAR(255), FK1_FOR_BEJB_1X1_UNI_BTOB VARCHAR(255), FK2_FOR_BEJB_1X1_UNI_BTOB VARCHAR(255)) !

drop table AEJB_1X1_UNI_BTOB cascade constraints !
CREATE TABLE  AEJB_1X1_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_1X1_UNI_BTOB cascade constraints !
CREATE TABLE BEJB_1X1_UNI_BTOB ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_1X1_UNI_BTOB VARCHAR(255)) !

ALTER TABLE BEANEJB_1X1_UNI_BTOB add ( constraint FK1_FOR_AEJB_1X1_UNI_BTOB Foreign Key (FK1_FOR_AEJB_1X1_UNI_BTOB) references AEJB_1X1_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_1X1_UNI_BTOB add ( constraint FK2_FOR_AEJB_1X1_UNI_BTOB Foreign Key (FK2_FOR_AEJB_1X1_UNI_BTOB) references AEJB_1X1_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_1X1_UNI_BTOB add ( constraint FK1_FOR_BEJB_1X1_UNI_BTOB Foreign Key (FK1_FOR_BEJB_1X1_UNI_BTOB) references BEJB_1X1_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_1X1_UNI_BTOB add ( constraint FK2_FOR_BEJB_1X1_UNI_BTOB Foreign Key (FK2_FOR_BEJB_1X1_UNI_BTOB) references BEJB_1X1_UNI_BTOB(id) ) !

ALTER TABLE BEJB_1X1_UNI_BTOB add ( constraint FK_FOR_AEJB_1X1_UNI_BTOB Foreign Key (FK_FOR_AEJB_1X1_UNI_BTOB) references AEJB_1X1_UNI_BTOB(id) ) !

drop table BEANEJB_1XM_BI_BTOB cascade constraints !
CREATE TABLE BEANEJB_1XM_BI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_1XM_BI_BTOB VARCHAR(255), FK2_FOR_AEJB_1XM_BI_BTOB VARCHAR(255), FK1_FOR_BEJB_1XM_BI_BTOB VARCHAR(255), FK2_FOR_BEJB_1XM_BI_BTOB VARCHAR(255), FK3_FOR_BEJB_1XM_BI_BTOB VARCHAR(255), FK4_FOR_BEJB_1XM_BI_BTOB VARCHAR(255)) !

drop table AEJB_1XM_BI_BTOB cascade constraints !
CREATE TABLE  AEJB_1XM_BI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_1XM_BI_BTOB cascade constraints !
CREATE TABLE BEJB_1XM_BI_BTOB ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_1XM_BI_BTOB VARCHAR(255)) !


ALTER TABLE BEANEJB_1XM_BI_BTOB add ( constraint FK1_FOR_AEJB_1XM_BI_BTOB Foreign Key (FK1_FOR_AEJB_1XM_BI_BTOB) references AEJB_1XM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_BI_BTOB add ( constraint FK2_FOR_AEJB_1XM_BI_BTOB Foreign Key (FK2_FOR_AEJB_1XM_BI_BTOB) references AEJB_1XM_BI_BTOB(id) ) !


ALTER TABLE BEANEJB_1XM_BI_BTOB add ( constraint FK1_FOR_BEJB_1XM_BI_BTOB Foreign Key (FK1_FOR_BEJB_1XM_BI_BTOB) references BEJB_1XM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_BI_BTOB add ( constraint FK2_FOR_BEJB_1XM_BI_BTOB Foreign Key (FK2_FOR_BEJB_1XM_BI_BTOB) references BEJB_1XM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_BI_BTOB add ( constraint FK3_FOR_BEJB_1XM_BI_BTOB Foreign Key (FK3_FOR_BEJB_1XM_BI_BTOB) references BEJB_1XM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_BI_BTOB add ( constraint FK4_FOR_BEJB_1XM_BI_BTOB Foreign Key (FK4_FOR_BEJB_1XM_BI_BTOB) references BEJB_1XM_BI_BTOB(id) ) !

ALTER TABLE BEJB_1XM_BI_BTOB add ( constraint FK_FOR_AEJB_1XM_BI_BTOB Foreign Key (FK_FOR_AEJB_1XM_BI_BTOB) references AEJB_1XM_BI_BTOB(id) ) !

drop table BEANEJB_1XM_BI_CASCADE cascade constraints !
CREATE TABLE BEANEJB_1XM_BI_CASCADE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_1XM_BI_CASCADE VARCHAR(255), FK2_FOR_AEJB_1XM_BI_CASCADE VARCHAR(255), FK1_FOR_BEJB_1XM_BI_CASCADE VARCHAR(255), FK2_FOR_BEJB_1XM_BI_CASCADE VARCHAR(255)) !

drop table AEJB_1XM_BI_CASCADE cascade constraints !
CREATE TABLE  AEJB_1XM_BI_CASCADE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_1XM_BI_CASCADE cascade constraints !
CREATE TABLE BEJB_1XM_BI_CASCADE ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_1XM_BI_CASCADE VARCHAR(255)) !


ALTER TABLE BEANEJB_1XM_BI_CASCADE add ( constraint FK1_FOR_AEJB_1XM_BI_CASCADE Foreign Key (FK1_FOR_AEJB_1XM_BI_CASCADE) references AEJB_1XM_BI_CASCADE(id)) !

ALTER TABLE BEANEJB_1XM_BI_CASCADE add ( constraint FK2_FOR_AEJB_1XM_BI_CASCADE Foreign Key (FK2_FOR_AEJB_1XM_BI_CASCADE) references AEJB_1XM_BI_CASCADE(id)) !

ALTER TABLE BEANEJB_1XM_BI_CASCADE add ( constraint FK1_FOR_BEJB_1XM_BI_CASCADE Foreign Key (FK1_FOR_BEJB_1XM_BI_CASCADE) references BEJB_1XM_BI_CASCADE(id)) !

ALTER TABLE BEANEJB_1XM_BI_CASCADE add ( constraint FK2_FOR_BEJB_1XM_BI_CASCADE Foreign Key (FK2_FOR_BEJB_1XM_BI_CASCADE) references BEJB_1XM_BI_CASCADE(id)) !

ALTER TABLE BEJB_1XM_BI_CASCADE add ( constraint FK_FOR_AEJB_1XM_BI_CASCADE Foreign Key (FK_FOR_AEJB_1XM_BI_CASCADE) references AEJB_1XM_BI_CASCADE(id)) !

drop table BEANEJB_1XM_BI_DELETE cascade constraints !
CREATE TABLE BEANEJB_1XM_BI_DELETE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_1XM_BI_DELETE VARCHAR(255), FK2_FOR_AEJB_1XM_BI_DELETE VARCHAR(255), FK1_FOR_BEJB_1XM_BI_DELETE VARCHAR(255), FK2_FOR_BEJB_1XM_BI_DELETE VARCHAR(255)) !

drop table AEJB_1XM_BI_DELETE cascade constraints !
CREATE TABLE  AEJB_1XM_BI_DELETE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_1XM_BI_DELETE cascade constraints !
CREATE TABLE BEJB_1XM_BI_DELETE ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_1XM_BI_DELETE VARCHAR(255)) !

ALTER TABLE BEANEJB_1XM_BI_DELETE add ( constraint FK1_FOR_AEJB_1XM_BI_DELETE Foreign Key (FK1_FOR_AEJB_1XM_BI_DELETE) references AEJB_1XM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_1XM_BI_DELETE add ( constraint FK2_FOR_AEJB_1XM_BI_DELETE Foreign Key (FK2_FOR_AEJB_1XM_BI_DELETE) references AEJB_1XM_BI_DELETE(id)) !


ALTER TABLE BEANEJB_1XM_BI_DELETE add ( constraint FK1_FOR_BEJB_1XM_BI_DELETE Foreign Key (FK1_FOR_BEJB_1XM_BI_DELETE) references BEJB_1XM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_1XM_BI_DELETE add ( constraint FK2_FOR_BEJB_1XM_BI_DELETE Foreign Key (FK2_FOR_BEJB_1XM_BI_DELETE) references BEJB_1XM_BI_DELETE(id)) !


ALTER TABLE BEJB_1XM_BI_DELETE add ( constraint FK_FOR_AEJB_1XM_BI_DELETE Foreign Key (FK_FOR_AEJB_1XM_BI_DELETE) references AEJB_1XM_BI_DELETE(id)) !

drop table BEANEJB_1XM_UNI_BTOB cascade constraints !
CREATE TABLE BEANEJB_1XM_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_1XM_UNI_BTOB VARCHAR(255), FK2_FOR_AEJB_1XM_UNI_BTOB VARCHAR(255), FK1_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255), FK2_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255), FK3_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255), FK4_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255)) !

drop table AEJB_1XM_UNI_BTOB cascade constraints !
CREATE TABLE  AEJB_1XM_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_1XM_UNI_BTOB cascade constraints !
CREATE TABLE BEJB_1XM_UNI_BTOB ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_1XM_UNI_BTOB VARCHAR(255)) !

ALTER TABLE BEANEJB_1XM_UNI_BTOB add ( constraint FK1_FOR_AEJB_1XM_UNI_BTOB Foreign Key (FK1_FOR_AEJB_1XM_UNI_BTOB) references AEJB_1XM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_UNI_BTOB add ( constraint FK2_FOR_AEJB_1XM_UNI_BTOB Foreign Key (FK2_FOR_AEJB_1XM_UNI_BTOB) references AEJB_1XM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_UNI_BTOB add ( constraint FK1_FOR_BEJB_1XM_UNI_BTOB Foreign Key (FK1_FOR_BEJB_1XM_UNI_BTOB) references BEJB_1XM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_UNI_BTOB add ( constraint FK2_FOR_BEJB_1XM_UNI_BTOB Foreign Key (FK2_FOR_BEJB_1XM_UNI_BTOB) references BEJB_1XM_UNI_BTOB(id) ) !


ALTER TABLE BEANEJB_1XM_UNI_BTOB add ( constraint FK3_FOR_BEJB_1XM_UNI_BTOB Foreign Key (FK3_FOR_BEJB_1XM_UNI_BTOB) references BEJB_1XM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_1XM_UNI_BTOB add ( constraint FK4_FOR_BEJB_1XM_UNI_BTOB Foreign Key (FK4_FOR_BEJB_1XM_UNI_BTOB) references BEJB_1XM_UNI_BTOB(id) ) !

ALTER TABLE BEJB_1XM_UNI_BTOB add ( constraint FK_FOR_AEJB_1XM_UNI_BTOB Foreign Key (FK_FOR_AEJB_1XM_UNI_BTOB) references AEJB_1XM_UNI_BTOB(id) ) !

drop table BEANEJB_MX1_UNI_BTOB cascade constraints !
CREATE TABLE BEANEJB_MX1_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_MX1_UNI_BTOB VARCHAR(255), FK2_FOR_AEJB_MX1_UNI_BTOB VARCHAR(255), FK1_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255), FK2_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255), FK3_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255), FK4_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255)) !

drop table AEJB_MX1_UNI_BTOB cascade constraints !
CREATE TABLE  AEJB_MX1_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_MX1_UNI_BTOB cascade constraints !
CREATE TABLE BEJB_MX1_UNI_BTOB ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_MX1_UNI_BTOB VARCHAR(255)) !

ALTER TABLE BEANEJB_MX1_UNI_BTOB add ( constraint FK1_FOR_AEJB_MX1_UNI_BTOB Foreign Key (FK1_FOR_AEJB_MX1_UNI_BTOB) references AEJB_MX1_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MX1_UNI_BTOB add ( constraint FK2_FOR_AEJB_MX1_UNI_BTOB Foreign Key (FK2_FOR_AEJB_MX1_UNI_BTOB) references AEJB_MX1_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MX1_UNI_BTOB add ( constraint FK1_FOR_BEJB_MX1_UNI_BTOB Foreign Key (FK1_FOR_BEJB_MX1_UNI_BTOB) references BEJB_MX1_UNI_BTOB(id) ) !


ALTER TABLE BEANEJB_MX1_UNI_BTOB add ( constraint FK2_FOR_BEJB_MX1_UNI_BTOB Foreign Key (FK2_FOR_BEJB_MX1_UNI_BTOB) references BEJB_MX1_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MX1_UNI_BTOB add ( constraint FK3_FOR_BEJB_MX1_UNI_BTOB Foreign Key (FK3_FOR_BEJB_MX1_UNI_BTOB) references BEJB_MX1_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MX1_UNI_BTOB add ( constraint FK4_FOR_BEJB_MX1_UNI_BTOB Foreign Key (FK4_FOR_BEJB_MX1_UNI_BTOB) references BEJB_MX1_UNI_BTOB(id) ) !


ALTER TABLE BEJB_MX1_UNI_BTOB add ( constraint FK_FOR_AEJB_MX1_UNI_BTOB Foreign Key (FK_FOR_AEJB_MX1_UNI_BTOB) references AEJB_MX1_UNI_BTOB(id) ) !

drop table BEANEJB_MX1_UNI_DELETE cascade constraints !
CREATE TABLE BEANEJB_MX1_UNI_DELETE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_MX1_UNI_DELETE VARCHAR(255) , FK2_FOR_AEJB_MX1_UNI_DELETE VARCHAR(255) , FK1_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) , FK2_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) , FK3_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) , FK4_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) ) !

drop table AEJB_MX1_UNI_DELETE cascade constraints !
CREATE TABLE  AEJB_MX1_UNI_DELETE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_MX1_UNI_DELETE cascade constraints !
CREATE TABLE BEJB_MX1_UNI_DELETE ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL, FK_FOR_AEJB_MX1_UNI_DELETE VARCHAR(255)) !

ALTER TABLE BEANEJB_MX1_UNI_DELETE add ( constraint FK1_FOR_AEJB_MX1_UNI_DELETE Foreign Key (FK1_FOR_AEJB_MX1_UNI_DELETE) references AEJB_MX1_UNI_DELETE(id)) !

ALTER TABLE BEANEJB_MX1_UNI_DELETE add ( constraint FK2_FOR_AEJB_MX1_UNI_DELETE Foreign Key (FK2_FOR_AEJB_MX1_UNI_DELETE) references AEJB_MX1_UNI_DELETE(id)) !

ALTER TABLE BEANEJB_MX1_UNI_DELETE add ( constraint FK1_FOR_BEJB_MX1_UNI_DELETE Foreign Key (FK1_FOR_BEJB_MX1_UNI_DELETE) references BEJB_MX1_UNI_DELETE(id)) !

ALTER TABLE BEANEJB_MX1_UNI_DELETE add ( constraint FK2_FOR_BEJB_MX1_UNI_DELETE Foreign Key (FK2_FOR_BEJB_MX1_UNI_DELETE) references BEJB_MX1_UNI_DELETE(id)) !


ALTER TABLE BEANEJB_MX1_UNI_DELETE add ( constraint FK3_FOR_BEJB_MX1_UNI_DELETE Foreign Key (FK3_FOR_BEJB_MX1_UNI_DELETE) references BEJB_MX1_UNI_DELETE(id)) !

ALTER TABLE BEANEJB_MX1_UNI_DELETE add ( constraint FK4_FOR_BEJB_MX1_UNI_DELETE Foreign Key (FK4_FOR_BEJB_MX1_UNI_DELETE) references BEJB_MX1_UNI_DELETE(id)) !

ALTER TABLE BEJB_MX1_UNI_DELETE add ( constraint FK_FOR_AEJB_MX1_UNI_DELETE Foreign Key (FK_FOR_AEJB_MX1_UNI_DELETE) references AEJB_MX1_UNI_DELETE(id)) !

drop table BEANEJB_MXM_BI_BTOB cascade constraints !
CREATE TABLE BEANEJB_MXM_BI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK2_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK3_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK4_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK1_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) , FK2_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) , FK3_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) , FK4_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) ) !

drop table AEJB_MXM_BI_BTOB cascade constraints !
CREATE TABLE  AEJB_MXM_BI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_MXM_BI_BTOB cascade  constraints !
CREATE TABLE BEJB_MXM_BI_BTOB ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL ) !

drop table FKEYS_MXM_BI_BTOB cascade constraints !
CREATE TABLE FKEYS_MXM_BI_BTOB ( FK_FOR_AEJB_MXM_BI_BTOB  VARCHAR(255), FK_FOR_BEJB_MXM_BI_BTOB  VARCHAR(255)) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK1_FOR_AEJB_MXM_BI_BTOB Foreign Key (FK1_FOR_AEJB_MXM_BI_BTOB) references AEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK2_FOR_AEJB_MXM_BI_BTOB Foreign Key (FK2_FOR_AEJB_MXM_BI_BTOB) references AEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK3_FOR_AEJB_MXM_BI_BTOB Foreign Key (FK3_FOR_AEJB_MXM_BI_BTOB) references AEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK4_FOR_AEJB_MXM_BI_BTOB Foreign Key (FK4_FOR_AEJB_MXM_BI_BTOB) references AEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK1_FOR_BEJB_MXM_BI_BTOB Foreign Key (FK1_FOR_BEJB_MXM_BI_BTOB) references BEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK2_FOR_BEJB_MXM_BI_BTOB Foreign Key (FK2_FOR_BEJB_MXM_BI_BTOB) references BEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK3_FOR_BEJB_MXM_BI_BTOB Foreign Key (FK3_FOR_BEJB_MXM_BI_BTOB) references BEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_BI_BTOB add ( constraint FK4_FOR_BEJB_MXM_BI_BTOB Foreign Key (FK4_FOR_BEJB_MXM_BI_BTOB) references BEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE FKEYS_MXM_BI_BTOB add ( constraint FK_FOR_AEJB_MXM_BI_BTOB Foreign Key (FK_FOR_AEJB_MXM_BI_BTOB) references AEJB_MXM_BI_BTOB(id) ) !

ALTER TABLE FKEYS_MXM_BI_BTOB add ( constraint FK_FOR_BEJB_MXM_BI_BTOB Foreign Key (FK_FOR_BEJB_MXM_BI_BTOB) references BEJB_MXM_BI_BTOB(id) ) !

drop table BEANEJB_MXM_BI_DELETE cascade constraints !
CREATE TABLE BEANEJB_MXM_BI_DELETE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK2_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK3_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK4_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK1_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) , FK2_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) , FK3_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) , FK4_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) ) !

drop table AEJB_MXM_BI_DELETE cascade constraints !
CREATE TABLE  AEJB_MXM_BI_DELETE ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_MXM_BI_DELETE cascade  constraints !
CREATE TABLE BEJB_MXM_BI_DELETE ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL ) !

drop table FKEYS_MXM_BI_DELETE cascade constraints !
CREATE TABLE FKEYS_MXM_BI_DELETE ( FK_FOR_AEJB_MXM_BI_DELETE  VARCHAR(255), FK_FOR_BEJB_MXM_BI_DELETE  VARCHAR(255)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK1_FOR_AEJB_MXM_BI_DELETE Foreign Key (FK1_FOR_AEJB_MXM_BI_DELETE) references AEJB_MXM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK2_FOR_AEJB_MXM_BI_DELETE Foreign Key (FK2_FOR_AEJB_MXM_BI_DELETE) references AEJB_MXM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK3_FOR_AEJB_MXM_BI_DELETE Foreign Key (FK3_FOR_AEJB_MXM_BI_DELETE) references AEJB_MXM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK4_FOR_AEJB_MXM_BI_DELETE Foreign Key (FK4_FOR_AEJB_MXM_BI_DELETE) references AEJB_MXM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK1_FOR_BEJB_MXM_BI_DELETE Foreign Key (FK1_FOR_BEJB_MXM_BI_DELETE) references BEJB_MXM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK2_FOR_BEJB_MXM_BI_DELETE Foreign Key (FK2_FOR_BEJB_MXM_BI_DELETE) references BEJB_MXM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK3_FOR_BEJB_MXM_BI_DELETE Foreign Key (FK3_FOR_BEJB_MXM_BI_DELETE) references BEJB_MXM_BI_DELETE(id)) !

ALTER TABLE BEANEJB_MXM_BI_DELETE add ( constraint FK4_FOR_BEJB_MXM_BI_DELETE Foreign Key (FK4_FOR_BEJB_MXM_BI_DELETE) references BEJB_MXM_BI_DELETE(id)) !

ALTER TABLE FKEYS_MXM_BI_DELETE add ( constraint FK_FOR_AEJB_MXM_BI_DELETE Foreign Key (FK_FOR_AEJB_MXM_BI_DELETE) references AEJB_MXM_BI_DELETE(id)) !

ALTER TABLE FKEYS_MXM_BI_DELETE add ( constraint FK_FOR_BEJB_MXM_BI_DELETE Foreign Key (FK_FOR_BEJB_MXM_BI_DELETE) references BEJB_MXM_BI_DELETE(id)) !

drop table BEANEJB_MXM_UNI_BTOB cascade constraints !
CREATE TABLE BEANEJB_MXM_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL, FK1_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK2_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK3_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK4_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK1_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) , FK2_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) , FK3_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) , FK4_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) ) !

drop table AEJB_MXM_UNI_BTOB cascade constraints !
CREATE TABLE  AEJB_MXM_UNI_BTOB ( id VARCHAR(255)  PRIMARY KEY, name VARCHAR(255) , value NUMBER NOT NULL) !

drop table BEJB_MXM_UNI_BTOB cascade  constraints !
CREATE TABLE BEJB_MXM_UNI_BTOB ( id  VARCHAR(255) PRIMARY KEY, name VARCHAR(255), value NUMBER NOT NULL ) !

drop table FKEYS_MXM_UNI_BTOB cascade constraints !
CREATE TABLE FKEYS_MXM_UNI_BTOB ( FK_FOR_AEJB_MXM_UNI_BTOB  VARCHAR(255), FK_FOR_BEJB_MXM_UNI_BTOB  VARCHAR(255)) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK1_FOR_AEJB_MXM_UNI_BTOB Foreign Key (FK1_FOR_AEJB_MXM_UNI_BTOB) references AEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK2_FOR_AEJB_MXM_UNI_BTOB Foreign Key (FK2_FOR_AEJB_MXM_UNI_BTOB) references AEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK3_FOR_AEJB_MXM_UNI_BTOB Foreign Key (FK3_FOR_AEJB_MXM_UNI_BTOB) references AEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK4_FOR_AEJB_MXM_UNI_BTOB Foreign Key (FK4_FOR_AEJB_MXM_UNI_BTOB) references AEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK1_FOR_BEJB_MXM_UNI_BTOB Foreign Key (FK1_FOR_BEJB_MXM_UNI_BTOB) references BEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK2_FOR_BEJB_MXM_UNI_BTOB Foreign Key (FK2_FOR_BEJB_MXM_UNI_BTOB) references BEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK3_FOR_BEJB_MXM_UNI_BTOB Foreign Key (FK3_FOR_BEJB_MXM_UNI_BTOB) references BEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE BEANEJB_MXM_UNI_BTOB add ( constraint FK4_FOR_BEJB_MXM_UNI_BTOB Foreign Key (FK4_FOR_BEJB_MXM_UNI_BTOB) references BEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE FKEYS_MXM_UNI_BTOB add ( constraint FK_FOR_AEJB_MXM_UNI_BTOB Foreign Key (FK_FOR_AEJB_MXM_UNI_BTOB) references AEJB_MXM_UNI_BTOB(id) ) !

ALTER TABLE FKEYS_MXM_UNI_BTOB add ( constraint FK_FOR_BEJB_MXM_UNI_BTOB Foreign Key (FK_FOR_BEJB_MXM_UNI_BTOB) references BEJB_MXM_UNI_BTOB(id) ) !

DROP TABLE PKEY !
CREATE TABLE PKEY ( PMIDINTEGER NUMBER NOT NULL, PMIDSTRING VARCHAR(25) NOT NULL, PMIDFLOAT REAL NOT NULL, BRANDNAME VARCHAR(25) , PRICE REAL , CONSTRAINT PK_PKEY PRIMARY KEY (PMIDINTEGER, PMIDSTRING, PMIDFLOAT)) !

DROP TABLE DATATYPES !
CREATE TABLE DATATYPES (ID NUMBER NOT NULL, BOOLEANDATA SMALLINT NULL, CHARDATA CHAR NULL, SHORTDATA SMALLINT NULL, INTDATA NUMBER NULL, INTDATA2 NUMBER NULL, LONGDATA NUMBER NULL, DBLDATA DOUBLE PRECISION NULL, FLOATDATA REAL NULL, ENUMODATA NUMBER NULL, ENUMSDATA VARCHAR(25) NULL,  BYTEDATA SMALLINT NULL, TRANS SMALLINT NULL,BYTEARRAYDATA BLOB NULL, CHARARRAYDATA VARCHAR2(255) NULL, CONSTRAINT PK_DATATYPE PRIMARY KEY (ID) )!

DROP TABLE DATATYPES2 !
CREATE TABLE DATATYPES2 ( DATATYPES2_ID DATE NOT NULL, DATEDATA DATE NULL, TIMEDATA DATE NULL, TSDATA DATE NULL, CONSTRAINT PK_DATATYPES2 PRIMARY KEY (DATATYPES2_ID))!

DROP TABLE DATATYPES3 !
CREATE TABLE DATATYPES3 ( ID DECIMAL(18,0) NOT NULL, THEVALUE DECIMAL(18,0), CONSTRAINT PK_DATATYPES3 PRIMARY KEY (ID)) !

DROP TABLE GENERATOR_TABLE !
CREATE TABLE GENERATOR_TABLE (PK_COL VARCHAR(10), VAL_COL NUMBER, CONSTRAINT GENERATOR_TABLE_PK PRIMARY KEY (PK_COL) ) !
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT_ID', 1) !
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT1_ID', 1) !
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT2_ID', 100) !
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT3_ID', 1000) !

DROP TABLE SEQUENCE !
CREATE TABLE SEQUENCE (SEQ_NAME VARCHAR(10), SEQ_COUNT NUMBER, CONSTRAINT SEQUENCE_PK PRIMARY KEY (SEQ_NAME) )!
INSERT into SEQUENCE(SEQ_NAME, SEQ_COUNT) values ('SEQ_GEN', 0) !


DROP TABLE ORDER1 cascade constraints !
CREATE TABLE ORDER1 (id INT PRIMARY KEY NOT NULL, totalPrice DOUBLE PRECISION , FK1_FOR_ITEM INT) !

DROP TABLE ORDER2 cascade constraints !
CREATE TABLE ORDER2 (id INT PRIMARY KEY NOT NULL, totalPrice DOUBLE PRECISION , FK2_FOR_ITEM INT) !

DROP TABLE ORDER3 cascade constraints !
CREATE TABLE ORDER3 (id INT PRIMARY KEY NOT NULL, totalPrice DOUBLE PRECISION , FK3_FOR_ITEM INT) !

DROP TABLE ITEM !
CREATE TABLE ITEM (ID INT PRIMARY KEY NOT NULL, ITEMNAME VARCHAR2(255)) !

ALTER TABLE ORDER1 add ( constraint FK1_FOR_ITEM Foreign Key (FK1_FOR_ITEM) references ITEM(ID) ) !
ALTER TABLE ORDER2 add ( constraint FK2_FOR_ITEM Foreign Key (FK2_FOR_ITEM) references ITEM(ID) ) !
ALTER TABLE ORDER3 add ( constraint FK3_FOR_ITEM Foreign Key (FK3_FOR_ITEM) references ITEM(ID) ) !

DROP TABLE MEMBER CASCADE CONSTRAINTS!
CREATE TABLE MEMBER (MEMBER_ID NUMBER NOT NULL, MEMBER_NAME VARCHAR(255), DUES SMALLINT NULL, VERSION NUMBER, DONATION NUMBER, CONSTRAINT PK_MEMBER PRIMARY KEY (MEMBER_ID)) !

DROP TABLE ACCOUNT !
CREATE TABLE ACCOUNT (ID NUMBER NOT NULL, BALANCE DOUBLE PRECISION, DEPOSIT DOUBLE PRECISION, WITHDRAW DOUBLE PRECISION, CONSTRAINT PK_ACCOUNT PRIMARY KEY (ID)) !

















DROP TABLE PARTTIMEEMPLOYEE  CASCADE CONSTRAINTS!
CREATE TABLE PARTTIMEEMPLOYEE (ID NUMBER NOT NULL, FIRSTNAME VARCHAR(255) , LASTNAME VARCHAR(255), HIREDATE DATE, SALARY REAL NOT NULL,  ADDRESS_ID VARCHAR(255), STATUS VARCHAR(255), FK_DEPT2 NUMERIC , FK_PROJECT NUMBER, CONSTRAINT PK_PARTTIMEEMP PRIMARY KEY (ID)) !
ALTER TABLE PARTTIMEEMPLOYEE ADD  CONSTRAINT FK_ADDR FOREIGN KEY (ADDRESS_ID) REFERENCES ADDRESS(ID) !

ALTER TABLE PARTTIMEEMPLOYEE ADD CONSTRAINT FK_DEPT2 FOREIGN KEY (FK_DEPT2) REFERENCES DEPARTMENT (ID) !

ALTER TABLE DATES_TABLE DROP CONSTRAINT FK_FOR_DATES_TABLE !

DROP TABLE A_BASIC  CASCADE CONSTRAINTS!
CREATE TABLE A_BASIC ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE NUMBER, BASICINTEGER NUMBER, BASICSHORT SMALLINT, BASICBIGSHORT SMALLINT, BASICFLOAT FLOAT, BASICBIGFLOAT FLOAT, BASICLONG NUMBER, BASICBIGLONG NUMBER, BASICDOUBLE DOUBLE PRECISION, BASICBIGDOUBLE DOUBLE PRECISION, BASICCHAR CHAR, BASICCHARARRAY VARCHAR(448), BASICBIGCHARARRAY VARCHAR(448), BASICBYTEARRAY   RAW(255), BASICBIGBYTEARRAY  LONG RAW, BASICBIGINTEGER DECIMAL(18,0), BASICBIGDECIMAL DECIMAL(18,0), BASICDATE DATE, BASICTIME DATE, BASICCALENDAR DATE, BASICTIMESTAMP TIMESTAMP ) !

DROP TABLE DATES_TABLE CASCADE CONSTRAINTS !
CREATE TABLE DATES_TABLE (ID VARCHAR(255), DATES VARCHAR(255), FK_FOR_DATES_TABLE VARCHAR(255)) !
ALTER TABLE DATES_TABLE ADD CONSTRAINT FK_FOR_DATES_TABLE FOREIGN KEY (FK_FOR_DATES_TABLE) REFERENCES A_BASIC (ID) !

DROP TABLE DATE_TABLE !
CREATE TABLE DATE_TABLE (ID DATE, STRINGVERSION VARCHAR(255)) !

DROP TABLE A_BIGINTEGER  CASCADE CONSTRAINTS !
CREATE TABLE A_BIGINTEGER ( ID VARCHAR(255), NAME VARCHAR(255) , VALUE NUMBER, BASICINTEGER NUMBER, BASICSHORT SMALLINT, BASICBIGSHORT SMALLINT, BASICFLOAT FLOAT, BASICBIGFLOAT FLOAT, BASICLONG NUMBER, BASICBIGLONG NUMBER, BASICDOUBLE DOUBLE PRECISION, BASICBIGDOUBLE DOUBLE PRECISION, BASICCHAR CHAR, BASICCHARARRAY VARCHAR(448), BASICBIGCHARARRAY VARCHAR(448), BASICBYTEARRAY   RAW(255), BASICBIGBYTEARRAY  LONG RAW, BASICBIGINTEGER DECIMAL(18,0) PRIMARY KEY NOT NULL, BASICBIGDECIMAL DECIMAL(18,0), BASICDATE DATE, BASICTIME DATE, BASICCALENDAR DATE, BASICTIMESTAMP TIMESTAMP ) !

DROP TABLE A_BIGDECIMAL  CASCADE CONSTRAINTS!
CREATE TABLE A_BIGDECIMAL ( ID VARCHAR(255), NAME VARCHAR(255) , VALUE NUMBER, BASICINTEGER NUMBER, BASICSHORT SMALLINT, BASICBIGSHORT SMALLINT, BASICFLOAT FLOAT, BASICBIGFLOAT FLOAT, BASICLONG NUMBER, BASICBIGLONG NUMBER, BASICDOUBLE DOUBLE PRECISION, BASICBIGDOUBLE DOUBLE PRECISION, BASICCHAR CHAR, BASICCHARARRAY VARCHAR(448), BASICBIGCHARARRAY VARCHAR(448), BASICBYTEARRAY   RAW(255), BASICBIGBYTEARRAY  LONG RAW, BASICBIGINTEGER DECIMAL(18,0), BASICBIGDECIMAL DECIMAL(18,0) PRIMARY KEY NOT NULL, BASICDATE DATE, BASICTIME DATE, BASICCALENDAR DATE, BASICTIMESTAMP TIMESTAMP )!

DROP TABLE BNE_1XM_BI_BTOB  CASCADE CONSTRAINTS!
CREATE TABLE BNE_1XM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, STREET VARCHAR(255), CITY VARCHAR(255), STATE VARCHAR(255), ZIP VARCHAR(255), PLUSFOUR VARCHAR(255), FK_FOR_ANE_1XM_BI_BTOB VARCHAR(255) ) !

DROP TABLE B_EMBEDDABLE  CASCADE CONSTRAINTS!
CREATE TABLE B_EMBEDDABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, STREET VARCHAR(255), CITY VARCHAR(255), STATE VARCHAR(255), ZIP VARCHAR(255), PLUSFOUR VARCHAR(255)) !

DROP TABLE MEMBER  CASCADE CONSTRAINTS!
CREATE TABLE MEMBER (MEMBER_ID INT NOT NULL, MEMBER_NAME VARCHAR(255), DUES SMALLINT, VERSION NUMBER, DONATION DECIMAL(18,0), CONSTRAINT PK_MEMBER PRIMARY KEY (MEMBER_ID))!

DROP TABLE ACCOUNT   CASCADE CONSTRAINTS!
CREATE TABLE ACCOUNT (ID INT NOT NULL, BALANCE DOUBLE PRECISION, DEPOSIT DOUBLE PRECISION, WITHDRAW DOUBLE PRECISION, CONSTRAINT PK_ACCOUNT PRIMARY KEY (ID))!

DROP TABLE SEMESTER  CASCADE CONSTRAINTS!
CREATE TABLE SEMESTER (ID NUMBER NOT NULL, PRIMARY KEY (ID))!

DROP TABLE STUDENT_COURSE  CASCADE CONSTRAINTS!
CREATE TABLE STUDENT_COURSE (Student_ID NUMBER NOT NULL, courses_ID NUMBER NOT NULL, PRIMARY KEY (Student_ID, courses_ID))!

DROP TABLE STUDENT  CASCADE CONSTRAINTS!
CREATE TABLE STUDENT (ID NUMBER NOT NULL, STUDENTNAME VARCHAR(255), PRIMARY KEY (ID))!

DROP TABLE COURSE  CASCADE CONSTRAINTS!
CREATE TABLE COURSE (ID NUMBER NOT NULL, COURSENAME VARCHAR(255), PRIMARY KEY (ID))!

DROP TABLE ENROLLMENTS  CASCADE CONSTRAINTS!
CREATE TABLE ENROLLMENTS (STUDENT INTEGER NOT NULL, ENROLLMENT_KEY INTEGER NOT NULL, SEMESTER INTEGER NOT NULL, PRIMARY KEY (STUDENT, ENROLLMENT_KEY, SEMESTER))!

DROP TABLE COURSE_STUDENT  CASCADE CONSTRAINTS!
CREATE TABLE COURSE_STUDENT (COURSE_ID INTEGER NOT NULL, STUDENT_ID INTEGER NOT NULL, STUDENTS_ORDER INTEGER, PRIMARY KEY (COURSE_ID , STUDENT_ID))!

ALTER TABLE STUDENT_COURSE ADD CONSTRAINT STDNTCOURSEStdntID FOREIGN KEY (Student_ID) REFERENCES STUDENT (ID)!
ALTER TABLE STUDENT_COURSE ADD CONSTRAINT STDNTCOURSEcrsesID FOREIGN KEY (courses_ID) REFERENCES COURSE (ID)!
ALTER TABLE ENROLLMENTS ADD CONSTRAINT ENROLLMENTSSTUDENT FOREIGN KEY (STUDENT) REFERENCES STUDENT (ID)!
ALTER TABLE ENROLLMENTS ADD CONSTRAINT NROLLMENTSSEMESTER FOREIGN KEY (SEMESTER) REFERENCES SEMESTER (ID)!
ALTER TABLE COURSE_STUDENT ADD CONSTRAINT CRSESTUDENTCurseID FOREIGN KEY (COURSE_ID) REFERENCES COURSE (ID)!
ALTER TABLE COURSE_STUDENT ADD CONSTRAINT CRSSTUDENTstdntsID FOREIGN KEY (STUDENT_ID) REFERENCES STUDENT (ID)!

DROP TABLE NOENTITYLISTENER_TABLE  CASCADE CONSTRAINTS!
CREATE TABLE NOENTITYLISTENER_TABLE(ID NUMBER  PRIMARY KEY NOT NULL) !

DROP TABLE COURSE_2  CASCADE CONSTRAINTS!
CREATE TABLE COURSE_2(ID NUMBER NOT NULL,NAME VARCHAR(255)) !

DROP TABLE STUDENT_2  CASCADE CONSTRAINTS!
CREATE TABLE STUDENT_2(ID NUMBER NOT NULL,NAME VARCHAR(255)) !

DROP TABLE STUDENT_2_COURSE_2  CASCADE CONSTRAINTS!
CREATE TABLE STUDENT_2_COURSE_2(COURSES_ID NUMBER,STUDENTS_ID NUMBER) !

DROP TABLE NAMEONLYINXML  CASCADE CONSTRAINTS!
CREATE TABLE NAMEONLYINXML(ID NUMBER) !

DROP TABLE NAMEONLYINANNOTATION  CASCADE CONSTRAINTS!
CREATE TABLE NAMEONLYINANNOTATION(ID NUMBER) !

DROP TABLE NAMEOVERRIDE  CASCADE CONSTRAINTS!
CREATE TABLE NAMEOVERRIDE (ID NUMBER) !

DROP TABLE NOENTITYANNOTATION  CASCADE CONSTRAINTS!
CREATE TABLE  NOENTITYANNOTATION(ID NUMBER) !

DROP TABLE BOOKSTORE  CASCADE CONSTRAINTS!
CREATE TABLE BOOKSTORE(ID NUMBER NOT NULL,NAME VARCHAR(255),LOCATION VARCHAR(255)) !

DROP TABLE COMPLAINT  CASCADE CONSTRAINTS!
CREATE TABLE COMPLAINT(ID NUMBER NOT NULL, COMPLAINTNUMBER NUMBER, NAME VARCHAR(255), ADDRESS VARCHAR(255)) !

DROP TABLE MOVIETICKET  CASCADE CONSTRAINTS!
CREATE TABLE MOVIETICKET(ID NUMBER NOT NULL, FILMNAME VARCHAR(255), FILMCODE VARCHAR(255)) !

DROP TABLE BOOK  CASCADE CONSTRAINTS!
CREATE TABLE BOOK(ID NUMBER NOT NULL, NAME VARCHAR(255), STATEOFUSA VARCHAR(255)) !

DROP TABLE LAWBOOK  CASCADE CONSTRAINTS!
CREATE TABLE LAWBOOK(ID NUMBER NOT NULL, BOOK_NAME VARCHAR(255), CATEGORY VARCHAR(255),PUBLISHER VARCHAR(255),COST INT) !

DROP TABLE EMPLOYEE_2  CASCADE CONSTRAINTS!
CREATE TABLE EMPLOYEE_2(ID NUMBER NOT NULL, CODE  VARCHAR(255), DEPARTMENT_ID NUMBER) !

DROP TABLE DEPARTMENT_2  CASCADE CONSTRAINTS!
CREATE TABLE DEPARTMENT_2(ID NUMBER NOT NULL,NAME  VARCHAR(255)) !

DROP TABLE THEATRELOCATION  CASCADE CONSTRAINTS!
CREATE TABLE THEATRELOCATION(ID NUMBER NOT NULL, CODE  VARCHAR(255)) !

DROP TABLE THEATRECOMPANY  CASCADE CONSTRAINTS!
CREATE TABLE THEATRECOMPANY(ID NUMBER NOT NULL,NAME  VARCHAR(255)) !

DROP TABLE THEATRELOCATION_THEATRECOMPANY !
CREATE TABLE THEATRELOCATION_THEATRECOMPANY(COMPANIES_ID NUMBER, LOCATIONS_ID NUMBER) !

DROP TABLE STORE  CASCADE CONSTRAINTS!
CREATE TABLE STORE(ID NUMBER NOT NULL, NAME VARCHAR(255)) !

DROP TABLE CUSTOMERS  CASCADE CONSTRAINTS!
CREATE TABLE CUSTOMERS(ID NUMBER NOT NULL, CUSTNAME VARCHAR(255), STORE_ID NUMBER) !

DROP TABLE CONSUMER  CASCADE CONSTRAINTS!
CREATE TABLE CONSUMER(ID NUMBER NOT NULL) !

DROP TABLE RETAILORDER  CASCADE CONSTRAINTS!
CREATE TABLE RETAILORDER(ID NUMBER NOT NULL, COST DOUBLE PRECISION) !

DROP TABLE RETAILORDER_CONSUMER  CASCADE CONSTRAINTS!
CREATE TABLE RETAILORDER_CONSUMER(CONSUMERS_ID  NUMBER NOT NULL,ORDERS_ID  NUMBER NOT NULL) !

DROP TABLE THEATRELOCATION1  CASCADE CONSTRAINTS!
CREATE TABLE THEATRELOCATION1(ID NUMBER NOT NULL, CODE  VARCHAR(255),TCOMP_ID NUMBER NOT NULL) !

DROP TABLE THEATRECOMPANY1  CASCADE CONSTRAINTS!
CREATE TABLE THEATRECOMPANY1(ID NUMBER NOT NULL,NAME  VARCHAR(255)) !

DROP TABLE CUBICLE  CASCADE CONSTRAINTS!
CREATE TABLE CUBICLE(ID NUMBER NOT NULL , LOCATION VARCHAR(255) NOT NULL, PRIMARY KEY(ID,LOCATION)) !

DROP TABLE HARDWARE  CASCADE CONSTRAINTS!
CREATE TABLE HARDWARE(ID NUMBER NOT NULL, CODE VARCHAR(255),CUBE_ID NUMBER NOT NULL, CUBE_LOCATION VARCHAR(255)) !

DROP TABLE CUSTOMER1  CASCADE CONSTRAINTS!
CREATE TABLE CUSTOMER1(ID NUMBER NOT NULL, NAME VARCHAR(255), CONSTRAINT PK_CUSTOMER1 PRIMARY KEY (ID)) !

DROP TABLE RETAILORDER1  CASCADE CONSTRAINTS!
CREATE  TABLE RETAILORDER1(ID NUMBER NOT NULL, COST DOUBLE PRECISION) !

DROP TABLE CUST_ORDER  CASCADE CONSTRAINTS!
CREATE TABLE  CUST_ORDER(CUSTID NUMBER NOT NULL,ORDERID NUMBER NOT NULL) !


DROP TABLE RETAILORDER2  CASCADE CONSTRAINTS!
CREATE  TABLE RETAILORDER2(ID NUMBER NOT NULL, COST DOUBLE PRECISION, FK_FOR_CUSTOMER1 INTEGER) !

ALTER TABLE RETAILORDER2 ADD CONSTRAINT FK_FOR_CUST FOREIGN KEY(FK_FOR_CUSTOMER1) REFERENCES CUSTOMER1(ID) !

ALTER TABLE UNI1X1PERSON DROP CONSTRAINT  N1X1PRSNPRJCTPRJID !
DROP TABLE UNI1X1PROJECT  CASCADE CONSTRAINTS!
DROP TABLE UNI1X1PERSON  CASCADE CONSTRAINTS!


CREATE TABLE UNI1X1PROJECT (PROJID NUMBER NOT NULL, BUDGET FLOAT, NAME VARCHAR(255), PRIMARY KEY (PROJID)) !
CREATE TABLE UNI1X1PERSON (ID NUMBER NOT NULL, NAME VARCHAR(255), PROJECT_PROJID NUMBER, PRIMARY KEY (ID)) !
ALTER TABLE UNI1X1PERSON ADD CONSTRAINT N1X1PRSNPRJCTPRJID FOREIGN KEY (PROJECT_PROJID) REFERENCES UNI1X1PROJECT (PROJID) !


ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT DROP CONSTRAINT N1XMPRSNNn1XMPrsnD !
ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT DROP CONSTRAINT  N1XMPRSNN1XprjctsD !
DROP TABLE UNI1XMPERSON_UNI1XMPROJECT  CASCADE CONSTRAINTS!
DROP TABLE UNI1XMPROJECT  CASCADE CONSTRAINTS!
DROP TABLE UNI1XMPERSON  CASCADE CONSTRAINTS!

CREATE TABLE UNI1XMPERSON_UNI1XMPROJECT (Uni1XMPerson_ID NUMBER NOT NULL, projects_ID NUMBER NOT NULL, PRIMARY KEY (Uni1XMPerson_ID, projects_ID)) !
CREATE TABLE UNI1XMPROJECT (ID NUMBER NOT NULL, NAME VARCHAR(255), BUDGET FLOAT, PRIMARY KEY (ID)) !
CREATE TABLE UNI1XMPERSON (ID NUMBER NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID)) !
ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT ADD CONSTRAINT N1XMPRSNNn1XMPrsnD FOREIGN KEY (Uni1XMPerson_ID) REFERENCES UNI1XMPERSON (ID) !
ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT ADD CONSTRAINT N1XMPRSNN1XprjctsD FOREIGN KEY (projects_ID) REFERENCES UNI1XMPROJECT (ID) !


ALTER TABLE UNIMX1PERSON DROP CONSTRAINT  NMX1PRSNNMX1PRJCTD !
DROP TABLE UNIMX1PROJECT  CASCADE CONSTRAINTS!
DROP TABLE UNIMX1PERSON  CASCADE CONSTRAINTS!



CREATE TABLE UNIMX1PROJECT (ID  NUMBER  NOT NULL, NAME VARCHAR(255), BUDGET REAL, PRIMARY KEY (ID)) !
CREATE TABLE UNIMX1PERSON (ID  NUMBER  NOT NULL, NAME VARCHAR(255), UNIMX1PROJECT_ID  NUMBER , PRIMARY KEY (ID)) !
ALTER TABLE UNIMX1PERSON ADD CONSTRAINT NMX1PRSNNMX1PRJCTD FOREIGN KEY (UNIMX1PROJECT_ID) REFERENCES UNIMX1PROJECT (ID) !


ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT drop constraint  NMXMPRSNNnMXMPrsnD !
ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT drop constraint  NMXMPRSNnMXMPrjctD !
DROP TABLE UNIMXMPERSON  CASCADE CONSTRAINTS!
DROP TABLE UNIMXMPROJECT  CASCADE CONSTRAINTS!
DROP TABLE UNIMXMPERSON_UNIMXMPROJECT  CASCADE CONSTRAINTS!

CREATE TABLE UNIMXMPERSON (ID  NUMBER  NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID)) !
CREATE TABLE UNIMXMPROJECT (ID  NUMBER  NOT NULL, NAME VARCHAR(255), BUDGET REAL, PRIMARY KEY (ID)) !
CREATE TABLE UNIMXMPERSON_UNIMXMPROJECT (UniMXMPerson_ID  NUMBER  NOT NULL, UniMXMProject_ID  NUMBER  NOT NULL, PRIMARY KEY (UniMXMPerson_ID, UniMXMProject_ID)) !
ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT ADD CONSTRAINT NMXMPRSNNnMXMPrsnD FOREIGN KEY (UniMXMPerson_ID) REFERENCES UNIMXMPERSON (ID) !
ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT ADD CONSTRAINT NMXMPRSNnMXMPrjctD FOREIGN KEY (UniMXMProject_ID) REFERENCES UNIMXMPROJECT (ID) !


ALTER TABLE BIDIR1X1PERSON drop constraint  BDR1X1PRSPRJCTPRJD !
DROP TABLE BIDIR1X1PERSON  CASCADE CONSTRAINTS!
DROP TABLE BIDIR1X1PROJECT  CASCADE CONSTRAINTS!

CREATE TABLE BIDIR1X1PERSON (ID  NUMBER  NOT NULL, NAME VARCHAR(255), PROJECT_PROJID  NUMBER , PRIMARY KEY (ID)) !
CREATE TABLE BIDIR1X1PROJECT (PROJID  NUMBER  NOT NULL, BUDGET REAL, NAME VARCHAR(255), PRIMARY KEY (PROJID)) !
ALTER TABLE BIDIR1X1PERSON ADD CONSTRAINT BDR1X1PRSPRJCTPRJD FOREIGN KEY (PROJECT_PROJID) REFERENCES BIDIR1X1PROJECT (PROJID) !


ALTER TABLE BIDIR1XMPROJECT drop constraint  BDR1XMPBDR1XMPRSND !
DROP TABLE BIDIR1XMPERSON  CASCADE CONSTRAINTS!
DROP TABLE BIDIR1XMPROJECT  CASCADE CONSTRAINTS!

CREATE TABLE BIDIR1XMPERSON (ID  NUMBER  NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID)) !
CREATE TABLE BIDIR1XMPROJECT (ID  NUMBER  NOT NULL, NAME VARCHAR(255), BUDGET REAL, BIDIR1XMPERSON_ID  NUMBER , PRIMARY KEY (ID)) !
ALTER TABLE BIDIR1XMPROJECT ADD CONSTRAINT BDR1XMPBDR1XMPRSND FOREIGN KEY (BIDIR1XMPERSON_ID) REFERENCES BIDIR1XMPERSON (ID) !


ALTER TABLE BIDIRMX1PERSON drop constraint  BDRMX1PRNMX1PRJCTD !
DROP TABLE BIDIRMX1PROJECT  CASCADE CONSTRAINTS!
DROP TABLE BIDIRMX1PERSON  CASCADE CONSTRAINTS!

CREATE TABLE BIDIRMX1PROJECT (ID  NUMBER  NOT NULL, NAME VARCHAR(255), BUDGET REAL, PRIMARY KEY (ID)) !
CREATE TABLE BIDIRMX1PERSON (ID  NUMBER  NOT NULL, NAME VARCHAR(255), UNIMX1PROJECT_ID  NUMBER , PRIMARY KEY (ID)) !
ALTER TABLE BIDIRMX1PERSON ADD CONSTRAINT BDRMX1PRNMX1PRJCTD FOREIGN KEY (UNIMX1PROJECT_ID) REFERENCES BIDIRMX1PROJECT (ID) !


ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT drop constraint  BDRMXMPBDRMXMPrsnD !
ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT drop constraint  BDRMXMBDRMXMPrjctD !
DROP TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT  CASCADE CONSTRAINTS!
DROP TABLE BIDIRMXMPERSON  CASCADE CONSTRAINTS!
DROP TABLE BIDIRMXMPROJECT  CASCADE CONSTRAINTS!

CREATE TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT (BIDIRMXMPerson_ID  NUMBER  NOT NULL, BIDIRMXMProject_ID  NUMBER  NOT NULL, PRIMARY KEY (BIDIRMXMPerson_ID, BIDIRMXMProject_ID)) !
CREATE TABLE BIDIRMXMPERSON (ID  NUMBER  NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID)) !
CREATE TABLE BIDIRMXMPROJECT (ID  NUMBER  NOT NULL, NAME VARCHAR(255), BUDGET REAL, PRIMARY KEY (ID)) !
ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT ADD CONSTRAINT BDRMXMPBDRMXMPrsnD FOREIGN KEY (BIDIRMXMPerson_ID) REFERENCES BIDIRMXMPERSON (ID) !
ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT ADD CONSTRAINT BDRMXMBDRMXMPrjctD FOREIGN KEY (BIDIRMXMProject_ID) REFERENCES BIDIRMXMPROJECT (ID) !


ALTER TABLE DID1DEPENDENT drop constraint  DID1DEPENDENTEMPID !
DROP TABLE DID1DEPENDENT  CASCADE CONSTRAINTS!
DROP TABLE DID1EMPLOYEE  CASCADE CONSTRAINTS!

CREATE TABLE DID1DEPENDENT (NAME VARCHAR(255) NOT NULL, EMP_ID  NUMBER  NOT NULL, PRIMARY KEY (NAME, EMP_ID)) !
CREATE TABLE DID1EMPLOYEE (ID  NUMBER  NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID)) !
ALTER TABLE DID1DEPENDENT ADD CONSTRAINT DID1DEPENDENTEMPID FOREIGN KEY (EMP_ID) REFERENCES DID1EMPLOYEE (ID) !


ALTER TABLE DID1BDEPENDENT drop constraint  DID1BDEPENDENTMPID !
DROP TABLE DID1BDEPENDENT  CASCADE CONSTRAINTS!
DROP TABLE DID1BEMPLOYEE  CASCADE CONSTRAINTS!

CREATE TABLE DID1BDEPENDENT (NAME VARCHAR(255) NOT NULL, EMP_ID NUMBER NOT NULL, PRIMARY KEY (NAME, EMP_ID)) !
CREATE TABLE DID1BEMPLOYEE (ID  NUMBER  NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID)) !
ALTER TABLE DID1BDEPENDENT ADD CONSTRAINT DID1BDEPENDENTMPID FOREIGN KEY (EMP_ID) REFERENCES DID1BEMPLOYEE (ID) !


ALTER TABLE DID2DEPENDENT drop constraint  DD2DPENDENTFRSTNME !
DROP TABLE DID2EMPLOYEE  CASCADE CONSTRAINTS!
DROP TABLE DID2DEPENDENT  CASCADE CONSTRAINTS!

CREATE TABLE DID2EMPLOYEE (FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, EMPNO INTEGER, PRIMARY KEY (FIRSTNAME, LASTNAME)) !
CREATE TABLE DID2DEPENDENT (NAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, FIRSTNAME, LASTNAME)) !
ALTER TABLE DID2DEPENDENT ADD CONSTRAINT DD2DPENDENTFRSTNME FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID2EMPLOYEE (FIRSTNAME, LASTNAME) !


ALTER TABLE DID2BDEPENDENT drop constraint  DD2BDPENDENTLSTNME !
DROP TABLE DID2BEMPLOYEE  CASCADE CONSTRAINTS!
DROP TABLE DID2BDEPENDENT  CASCADE CONSTRAINTS!

CREATE TABLE DID2BEMPLOYEE (LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, EMPNO INTEGER, PRIMARY KEY (LASTNAME, FIRSTNAME)) !
CREATE TABLE DID2BDEPENDENT (NAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, LASTNAME, FIRSTNAME)) !
ALTER TABLE DID2BDEPENDENT ADD CONSTRAINT DD2BDPENDENTLSTNME FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID2BEMPLOYEE (LASTNAME, FIRSTNAME) !


ALTER TABLE DID3DEPENDENT drop constraint  DD3DPENDENTFRSTNME !
DROP TABLE DID3EMPLOYEE  CASCADE CONSTRAINTS!
DROP TABLE DID3DEPENDENT  CASCADE CONSTRAINTS!

CREATE TABLE DID3EMPLOYEE (FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME)) !
CREATE TABLE DID3DEPENDENT (NAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, FIRSTNAME, LASTNAME)) !
ALTER TABLE DID3DEPENDENT ADD CONSTRAINT DD3DPENDENTFRSTNME FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID3EMPLOYEE (FIRSTNAME, LASTNAME) !


ALTER TABLE DID3BDEPENDENT drop constraint  DD3BDPENDENTLSTNME !
DROP TABLE DID3BEMPLOYEE  CASCADE CONSTRAINTS!
DROP TABLE DID3BDEPENDENT  CASCADE CONSTRAINTS!

CREATE TABLE DID3BEMPLOYEE (LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME)) !
CREATE TABLE DID3BDEPENDENT (NAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, LASTNAME, FIRSTNAME)) !
ALTER TABLE DID3BDEPENDENT ADD CONSTRAINT DD3BDPENDENTLSTNME FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID3BEMPLOYEE (LASTNAME, FIRSTNAME) !


ALTER TABLE DID4MEDICALHISTORY drop constraint  DD4MDCLHSTRPTNTSSN !
DROP TABLE DID4MEDICALHISTORY  CASCADE CONSTRAINTS!
DROP TABLE DID4PERSON  CASCADE CONSTRAINTS!

CREATE TABLE DID4MEDICALHISTORY (DOCTORNAME VARCHAR(255), PATIENT_SSN VARCHAR(255) NOT NULL, PRIMARY KEY (PATIENT_SSN)) !
CREATE TABLE DID4PERSON (SSN VARCHAR(255) NOT NULL, NAME VARCHAR(255), PRIMARY KEY (SSN)) !
ALTER TABLE DID4MEDICALHISTORY ADD CONSTRAINT DD4MDCLHSTRPTNTSSN FOREIGN KEY (PATIENT_SSN) REFERENCES DID4PERSON (SSN) !


ALTER TABLE DID4BMEDICALHISTORY drop constraint  DD4BMDCLHSTPTNTSSN !
DROP TABLE DID4BMEDICALHISTORY  CASCADE CONSTRAINTS!
DROP TABLE DID4BPERSON  CASCADE CONSTRAINTS!

CREATE TABLE DID4BMEDICALHISTORY (ID VARCHAR(255) NOT NULL, DOCTORNAME VARCHAR(255), PRIMARY KEY (ID)) !
CREATE TABLE DID4BPERSON (SSN VARCHAR(255) NOT NULL, NAME VARCHAR(255), PRIMARY KEY (SSN)) !
ALTER TABLE DID4BMEDICALHISTORY ADD CONSTRAINT DD4BMDCLHSTPTNTSSN FOREIGN KEY (ID) REFERENCES DID4BPERSON (SSN) !


ALTER TABLE DID5MEDICALHISTORY drop constraint  DD5MDCLHSTRYFRSTNM !
DROP TABLE DID5PERSON  CASCADE CONSTRAINTS!
DROP TABLE DID5MEDICALHISTORY  CASCADE CONSTRAINTS!

CREATE TABLE DID5PERSON (FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, SSN VARCHAR(255), PRIMARY KEY (FIRSTNAME, LASTNAME)) !
CREATE TABLE DID5MEDICALHISTORY (DOCTORNAME VARCHAR(255), FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME)) !
ALTER TABLE DID5MEDICALHISTORY ADD CONSTRAINT DD5MDCLHSTRYFRSTNM FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID5PERSON (FIRSTNAME, LASTNAME) !


ALTER TABLE DID5BMEDICALHISTORY drop constraint  DD5BMDCLHSTRYLSTNM !
DROP TABLE DID5BMEDICALHISTORY  CASCADE CONSTRAINTS!
DROP TABLE DID5BPERSON  CASCADE CONSTRAINTS!

CREATE TABLE DID5BMEDICALHISTORY (DOCTORNAME VARCHAR(255), LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME)) !
CREATE TABLE DID5BPERSON (LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, SSN VARCHAR(255), PRIMARY KEY (LASTNAME, FIRSTNAME)) !
ALTER TABLE DID5BMEDICALHISTORY ADD CONSTRAINT DD5BMDCLHSTRYLSTNM FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID5BPERSON (LASTNAME, FIRSTNAME) !


ALTER TABLE DID6MEDICALHISTORY drop constraint  DD6MDCLHSTRYFRSTNM !
DROP TABLE DID6MEDICALHISTORY  CASCADE CONSTRAINTS!
DROP TABLE DID6PERSON  CASCADE CONSTRAINTS!

CREATE TABLE DID6MEDICALHISTORY (DOCTORNAME VARCHAR(255), FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME)) !
CREATE TABLE DID6PERSON (SSN VARCHAR(255), FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME)) !
ALTER TABLE DID6MEDICALHISTORY ADD CONSTRAINT DD6MDCLHSTRYFRSTNM FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID6PERSON (FIRSTNAME, LASTNAME) !

ALTER TABLE DID6BMEDICALHISTORY drop constraint  DD6BMDCLHSTRYLSTNM !
DROP TABLE DID6BPERSON  CASCADE CONSTRAINTS!
DROP TABLE DID6BMEDICALHISTORY  CASCADE CONSTRAINTS!

CREATE TABLE DID6BPERSON (SSN VARCHAR(255), LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME)) !
CREATE TABLE DID6BMEDICALHISTORY (DOCTORNAME VARCHAR(255), LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME)) !
ALTER TABLE DID6BMEDICALHISTORY ADD CONSTRAINT DD6BMDCLHSTRYLSTNM FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID6BPERSON (LASTNAME, FIRSTNAME) !

DROP TABLE A_ADDRESS  CASCADE CONSTRAINTS!
CREATE TABLE A_ADDRESS ( A_ID VARCHAR(255) NOT NULL,  STREET VARCHAR(30), CITY VARCHAR(30), STATE VARCHAR(2), ZIP VARCHAR(10) )!

DROP TABLE COLTAB_ADDRESS  CASCADE CONSTRAINTS!
CREATE TABLE COLTAB_ADDRESS ( A_ID VARCHAR(255) NOT NULL,  STREET VARCHAR(30), CITY VARCHAR(30), STATE VARCHAR(2), ZIP VARCHAR(10) )!

DROP TABLE AEC  CASCADE CONSTRAINTS!
CREATE TABLE AEC ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) ) !

DROP TABLE COLTAB  CASCADE CONSTRAINTS!
CREATE TABLE COLTAB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) ) !

DROP TABLE ANE_1XM_BI_BTOB  CASCADE CONSTRAINTS!
CREATE TABLE ANE_1XM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL ) !
ALTER TABLE BNE_1XM_BI_BTOB ADD CONSTRAINT FK_FOR_ANE_1XM_BI FOREIGN KEY (FK_FOR_ANE_1XM_BI_BTOB) REFERENCES ANE_1XM_BI_BTOB (ID) !

DROP TABLE EMP_MAPKEYCOL CASCADE CONSTRAINTS !
CREATE TABLE EMP_MAPKEYCOL(ID NUMBER NOT NULL, FIRSTNAME VARCHAR(255) NULL, LASTNAME VARCHAR(255) NULL, HIREDATE DATE NULL, SALARY REAL NOT NULL, STATUS VARCHAR(255),  FK_MGR NUMBER NULL, FK_DEPT NUMBER NULL, FK_DEPT3 NUMBER NULL, FK_DEPT4 NUMBER NULL, FK_PROJECT NUMBER NULL, FK_INS NUMBER NULL, OFFICE_ID VARCHAR(255), LASTNAMEEMPLOYEES_KEY VARCHAR(255), CONSTRAINT PK_EMP_MAPKEYCOL PRIMARY KEY (ID)) !
ALTER TABLE EMP_MAPKEYCOL ADD ( CONSTRAINT FK_DEPT1 FOREIGN KEY (FK_DEPT) REFERENCES DEPARTMENT (ID))!
ALTER TABLE EMP_MAPKEYCOL ADD ( CONSTRAINT FK_DEPT3 FOREIGN KEY (FK_DEPT3) REFERENCES DEPARTMENT (ID)) !
ALTER TABLE EMP_MAPKEYCOL ADD ( CONSTRAINT FK_DEPT4 FOREIGN KEY (FK_DEPT4) REFERENCES DEPARTMENT (ID)) !

CREATE TABLE EMP_MAPKEYCOL2(ID NUMBER NOT NULL, LASTNAME VARCHAR(255), THEDATE DATE ,FK_DEPT5 INT,  CONSTRAINT PK_EMP2 PRIMARY KEY (ID)) !
ALTER TABLE EMP_MAPKEYCOL2 ADD ( CONSTRAINT FK_DEPT5 FOREIGN KEY (FK_DEPT5) REFERENCES DEPARTMENT2 (ID)) !


ALTER TABLE COLTAB_EMP_EMBEDED_ADDRESS drop CONSTRAINT FK_EMPEMBADDRID !
DROP TABLE COLTAB_EMP_EMBEDED_ADDRESS !
DROP TABLE EMPLOYEE_EMBEDED_ADDRESS !
CREATE TABLE EMPLOYEE_EMBEDED_ADDRESS (ID INTEGER NOT NULL, FIRSTNAME VARCHAR(255), LASTNAME VARCHAR(255), PRIMARY KEY (ID)) !
CREATE TABLE COLTAB_EMP_EMBEDED_ADDRESS (ADDRESS_LOCATION VARCHAR(255), STREET VARCHAR(255), STATE VARCHAR(255), ZIP VARCHAR(255), CITY VARCHAR(255), ID VARCHAR(255), EMPEMBADDRID INTEGER) !
ALTER TABLE COLTAB_EMP_EMBEDED_ADDRESS ADD ( CONSTRAINT FK_EMPEMBADDRID FOREIGN KEY (EMPEMBADDRID) REFERENCES EMPLOYEE_EMBEDED_ADDRESS (ID) ) !

DROP SEQUENCE SEQGENERATOR !
CREATE SEQUENCE SEQGENERATOR START WITH 10 !
