/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.annotations.convert;

import javax.persistence.*;


@Embeddable
@Access(AccessType.FIELD)
public class Country implements java.io.Serializable {

    // Instance variables
    @Basic
    @Convert(converter=SpaceConverter.class)
    private String country;
    @Basic
    private String code;

    public Country() {
    }


    public Country(String v1, String v2) {
        country = v1;
        code = v2;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String v) {
        country = v;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String v) {
        code = v;
    }


    public boolean equals(Object o) {
        Country other;
        boolean same = false;

        if (!(o instanceof Country)) {
            return false;
        }
        other = (Country) o;

        same = this.country.equals(other.country) && (this.code.equals(other.code));

        return same;
    }


    public int hashCode() {
        int myHash;

        myHash = this.country.hashCode() + this.code.hashCode();

        return myHash;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("country: " + getCountry());
        result.append(", code: " + getCode());
        result.append("]");
        return result.toString();
    }
}
