/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.mapsid;

import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
public class DID1bDependent implements Serializable {

    private static final long serialVersionUID = 1L;
    @EmbeddedId DID1bDependentId id;

    @MapsId("empPK") 
    @ManyToOne DID1bEmployee emp;

    public DID1bDependent() {
    }

    public DID1bDependent(DID1bDependentId id, DID1bEmployee emp) {
        this.id = id;
        this.emp = emp;
    }

    public DID1bEmployee getEmp() {
        return emp;
    }

    public void setEmp(DID1bEmployee emp) {
        this.emp = emp;
    }

    @Override
    public String toString() {
        return "ex1b.DID1bDependent[id=" + id + "]";
    }
}
