 /*
 * Copyright (c) 2013, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.nativequery;

 public class PurchaseOrder implements java.io.Serializable {
	private static final long serialVersionUID = 22L;
	private int id;
     private int total;

     public PurchaseOrder() {
     }

     public PurchaseOrder(int total) {
         this.total = total;
     }
     
     public PurchaseOrder(Number total) {
         this.total = total.intValue();
     }     

     public PurchaseOrder(int id, int total) {
         this.id = id;
         this.total = total;
     }
     
     public PurchaseOrder(Number id, Number total) {
         this.id = id.intValue();
         this.total = total.intValue();
     }     

     public int getId() {
         return id;
     }

     public void setId(int id) {
         this.id = id;
     }

     public int getTotal() {
         return total;
     }

     public void setTotal(int total) {
         this.total = total;
     }

     @Override
     public String toString() {
         return "Order id=" + getId() + ", total=" + getTotal();
     }

     @Override
     public int hashCode() {
         int myHash;

         myHash = this.getId() + this.getTotal();

         return myHash;
     }


     @Override
     public boolean equals(Object o) {
         PurchaseOrder other;
         boolean result = false;

         if (!(o instanceof PurchaseOrder)) {
             return result;
         }
         other = (PurchaseOrder) o;

         if (this.getId()==other.getId() &&
                 this.getTotal()==(other.getTotal())) {
             result = true;
         }

         return result;
     }
 }
