/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.onexmanyuni;

import javax.persistence.*;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Entity
public class Customer1 implements Serializable {

    @Id
    private Long id;
    private String name;
    @OneToMany(cascade = CascadeType.ALL,orphanRemoval = true)
    @JoinColumn(name = "FK_FOR_CUSTOMER1")
    private Set<RetailOrder2> orders = new HashSet();

    public Customer1() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int hash = 0;
        hash += (this.getId() != null ? this.getId().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Customer1)) {
            return false;
        }
        Customer1 other = (Customer1) object;
        if (this.getId() != other.getId() && (this.getId() == null ||
                !this.getId().equals(other.getId()))) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "com.sun.ts.tests.jpa.core.annotations.onexmanyuni." +
                "Customer1[id=" + getId() + "]";
    }

    public Set<RetailOrder2> getOrders() {
        return orders;
    }

    public void setOrders(Set<RetailOrder2> orders) {
        this.orders = orders;
    }

    public void addOrder(RetailOrder2 order) {
        this.getOrders().add(order);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
