/*
* Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

package com.sun.ts.tests.jpa.core.entitytest.apitests;

import javax.persistence.*;

@NamedNativeQueries({
        @NamedNativeQuery(name = "findDecafSQLCoffees",
                query = "Select c.\"ID\", c.\"BRANDNAME\", c.\"PRICE\" from \"COFFEE\" c where c.\"BRANDNAME\" like '%decaf%' ",
                resultClass = com.sun.ts.tests.jpa.core.entitytest.apitests.Coffee.class)
})
@NamedQueries({
        @NamedQuery(name = "findDecafCoffees",
                query = "Select c from Coffee c where c.brandName like '%decaf%'")
})

@MappedSuperclass()
public abstract class CoffeeMappedSC implements java.io.Serializable {

    private String brandName;

    protected CoffeeMappedSC() {
    }

    protected CoffeeMappedSC(String brandName) {
        this.brandName = brandName;
    }

    // ===========================================================
    // getters and setters for the state fields

    @Column(name = "BRANDNAME")
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String bName) {
        this.brandName = bName;
    }

}

