/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jpa.core.lock.query;

import javax.persistence.*;
import java.util.Collection;


/*
 * Department
 */

@Entity
@Table(name="DEPARTMENT")
public class Department implements java.io.Serializable {

    // Instance variables
    private int  id;
    private String  name;
    private Collection<Employee> employees = new java.util.ArrayList<Employee>();

    public Department() {
    }

    public Department(int id, String name) {
        this.id = id;
        this.name = name;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="NAME")
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    // ===========================================================
    // getters and setters for the association fields

    @OneToMany(cascade=CascadeType.ALL, mappedBy="department")
    public Collection<Employee> getEmployees() {
        return employees;
    }
    public void setEmployees(Collection<Employee> employees) {
        this.employees = employees;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("id: " + getId());
        result.append(", name: " + getName());
        result.append("]");
        return result.toString();
    }

}

