/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.metamodelapi.metamodel;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Date;

@MappedSuperclass()
public abstract class Employee implements Serializable{
    @Id
    private  int	 id;
    @Version
    private Integer version;

    private  String	     firstName;
    private  String	     lastName;
    private  Date	     hireDate;


    public Employee() {}

    public Employee(int id, String firstName, String lastName, Date hireDate){
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.hireDate = hireDate;
    }

   // ===========================================================
   // getters and setters for the state fields

    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    public Integer getVersion() {
        return version;
    }
    public void setVersion(Integer ver) {
        this.version = ver;
    }

    @Column(name="FIRSTNAMExx")
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAMExx")
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="HIREDATExx")
    public Date getHireDate() {
        return hireDate;
    }
    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

}



