/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.jpa22.se.repeatable.secondarytable;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

/*
 * HardwareProduct
 */

@Entity
@DiscriminatorValue("HW")
public class HardwareProduct extends Product
        implements java.io.Serializable {

	private static final long serialVersionUID = 22L;
	// Instance variables
    private int modelNumber;

    public HardwareProduct() {
        super();
    }


    // ===========================================================
    // getters and setters for the state fields

    @Column(name = "MODEL", nullable = true)
    public int getModelNumber() {
        return modelNumber;
    }

    public void setModelNumber(int modelNumber) {
        this.modelNumber = modelNumber;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", modelNumber: " + getModelNumber());
        result.append(", quantity: " + getQuantity());
        result.append("]");
        return result.toString();
    }
}
