/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.util.HashSet;
import javasoft.sqe.apiCheck.Equalizer;
import javasoft.sqe.apiCheck.Fatal;
import javasoft.sqe.apiCheck.InheritedUtil;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.Pairs;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XClassConstructor;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMember;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XNode;
import javasoft.sqe.apiCheck.XPack;
import javasoft.sqe.apiCheck.XProg;

class XProgComp {
    PackageSet packs;
    int access;
    static final int xvis = 5;
    EqName eqname = new EqName();
    EqMember eqmember = new EqMember();
    EqConstructor eqctor = new EqConstructor();
    EqMethod eqmethod = new EqMethod();
    final int stackdepth = 64;
    int stackidx;
    Pairs[] stack = new Pairs[64];
    Pairs tos;
    HashSet basevisited = new HashSet();
    HashSet testvisited = new HashSet();

    XProgComp() {
    }

    void Compare(PackageSet ps, XProg base, XProg test, String acc) {
        this.packs = ps;
        if (acc.equals("public")) {
            this.access = 1;
        } else if (acc.equals("protected")) {
            this.access = 2;
        } else if (acc.equals("package")) {
            this.access = 3;
        } else if (acc.equals("private")) {
            this.access = 4;
        } else {
            System.err.println("access selector must be public, protected, package or private");
            this.access = 2;
        }
        this.stackidx = -1;
        this.tos = null;
        this.Compare(base.packs, test.packs);
        this.packs = null;
    }

    void Compare(XPack base, XPack test) {
        int i;
        if (!this.packs.OnPath(base.FullName()) && !this.packs.OnPath(test.FullName())) {
            return;
        }
        Pairs memb = new Pairs(null, null);
        if (this.packs.InPath(base.FullName()) || this.packs.InPath(test.FullName())) {
            XClass x;
            memb.Init(base.classes, test.classes, this.eqmember);
            for (i = 0; i < memb.basedcl.size(); ++i) {
                XClass b = (XClass)memb.basedcl.elementAt(i);
                XClass t = (XClass)memb.testdcl.elementAt(i);
                if (!b.defined) {
                    this.Added(b);
                    continue;
                }
                if (!t.defined) {
                    this.Deleted(t);
                    continue;
                }
                this.XCompare(b, t);
            }
            for (i = 0; i < memb.deleted.size(); ++i) {
                x = (XClass)memb.deleted.elementAt(i);
                this.Normalize(x);
                this.Deleted(x);
            }
            for (i = 0; i < memb.added.size(); ++i) {
                x = (XClass)memb.added.elementAt(i);
                this.Normalize(x);
                this.Added(x);
            }
        }
        memb.Init(base.packs, test.packs, this.eqname);
        for (i = 0; i < memb.basedcl.size(); ++i) {
            this.Compare((XPack)memb.basedcl.elementAt(i), (XPack)memb.testdcl.elementAt(i));
        }
        for (i = 0; i < memb.deleted.size(); ++i) {
            this.Deleted((XPack)memb.deleted.elementAt(i));
        }
        for (i = 0; i < memb.added.size(); ++i) {
            this.Added((XPack)memb.added.elementAt(i));
        }
    }

    void Deleted(XPack xpack) {
        int i;
        for (i = 0; i < xpack.classes.size(); ++i) {
            XClass x = (XClass)xpack.classes.elementAt(i);
            if (!this.eqmember.Visible(x)) continue;
            this.Normalize(x);
            this.Deleted(x);
        }
        for (i = 0; i < xpack.packs.size(); ++i) {
            this.Deleted((XPack)xpack.packs.elementAt(i));
        }
    }

    void Added(XPack xpack) {
        int i;
        for (i = 0; i < xpack.classes.size(); ++i) {
            XClass x = (XClass)xpack.classes.elementAt(i);
            if (!this.eqmember.Visible(x)) continue;
            this.Normalize(x);
            this.Added(x);
        }
        for (i = 0; i < xpack.packs.size(); ++i) {
            this.Added((XPack)xpack.packs.elementAt(i));
        }
    }

    void XCompare(XClass base, XClass test) {
        boolean bv = this.basevisited.contains(base);
        boolean tv = this.testvisited.contains(test);
        if (bv && tv) {
            return;
        }
        if (bv || tv) {
            Fatal.Stop("visited: " + base.FullName() + " or " + test.FullName());
        }
        this.basevisited.add(base);
        this.testvisited.add(test);
        this.Normalize(base);
        this.Normalize(test);
        this.Compare(base, test);
    }

    void Compare(XClass b, XClass t) {
    }

    void CompareMembers(XClass base, XClass test) {
        int i;
        if (++this.stackidx == 64) {
            Fatal.Stop("XProgComp stack overflow");
        }
        this.stack[this.stackidx] = this.tos = new Pairs(base, test);
        this.tos.Init(base.constructors, test.constructors, this.eqctor);
        for (i = 0; i < this.tos.basedcl.size(); ++i) {
            this.Compare((XClassConstructor)this.tos.basedcl.elementAt(i), (XClassConstructor)this.tos.testdcl.elementAt(i));
        }
        for (i = 0; i < this.tos.deleted.size(); ++i) {
            this.Deleted((XClassConstructor)this.tos.deleted.elementAt(i));
        }
        for (i = 0; i < this.tos.added.size(); ++i) {
            this.Added((XClassConstructor)this.tos.added.elementAt(i));
        }
        this.tos.Init(base.methods, test.methods, this.eqmethod);
        for (i = 0; i < this.tos.basedcl.size(); ++i) {
            this.Compare((XClassMethod)this.tos.basedcl.elementAt(i), (XClassMethod)this.tos.testdcl.elementAt(i));
        }
        XClassMethod method = null;
        for (i = 0; i < this.tos.deleted.size(); ++i) {
            method = (XClassMethod)this.tos.deleted.elementAt(i);
            boolean methodInherited = false;
            System.err.println("### Method may be deleted \"" + method.home.FullName() + "." + method.name + "()\"");
            try {
                methodInherited = InheritedUtil.instance().methodIsInherited(method);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (methodInherited) continue;
            this.Deleted(method);
        }
        for (i = 0; i < this.tos.added.size(); ++i) {
            method = (XClassMethod)this.tos.added.elementAt(i);
            boolean methodOverridden = false;
            System.err.println("### Method may be added \"" + method.home.FullName() + "." + method.name + "()\"");
            try {
                methodOverridden = InheritedUtil.instance().methodIsOverridden(method);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (methodOverridden) continue;
            this.Added(method);
        }
        this.tos.Init(base.fields, test.fields, this.eqmember);
        for (i = 0; i < this.tos.basedcl.size(); ++i) {
            this.Compare((XClassField)this.tos.basedcl.elementAt(i), (XClassField)this.tos.testdcl.elementAt(i));
        }
        XClassField field = null;
        for (i = 0; i < this.tos.deleted.size(); ++i) {
            field = (XClassField)this.tos.deleted.elementAt(i);
            boolean fieldInherited = false;
            System.err.println("### Field may be deleted \"" + field.home.FullName() + "." + field.name + "\"");
            try {
                fieldInherited = InheritedUtil.instance().fieldIsInherited(field);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fieldInherited) continue;
            this.Deleted(field);
        }
        for (i = 0; i < this.tos.added.size(); ++i) {
            field = (XClassField)this.tos.added.elementAt(i);
            boolean fieldOverridden = false;
            System.err.println("### Field may be added \"" + field.home.FullName() + "." + field.name + "\"");
            try {
                fieldOverridden = InheritedUtil.instance().fieldIsOverridden(field);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fieldOverridden) continue;
            this.Added(field);
        }
        this.tos.Init(base.inners, test.inners, this.eqmember);
        for (i = 0; i < this.tos.basedcl.size(); ++i) {
            this.XCompare((XClass)this.tos.basedcl.elementAt(i), (XClass)this.tos.testdcl.elementAt(i));
        }
        for (i = 0; i < this.tos.deleted.size(); ++i) {
            this.Deleted((XClass)this.tos.deleted.elementAt(i));
        }
        for (i = 0; i < this.tos.added.size(); ++i) {
            this.Added((XClass)this.tos.added.elementAt(i));
        }
        this.stack[this.stackidx] = null;
        this.tos.Clear();
        this.tos = --this.stackidx < 0 ? null : this.stack[this.stackidx];
    }

    void Deleted(XClass x) {
    }

    void Added(XClass x) {
    }

    void Compare(XClassConstructor base, XClassConstructor test) {
    }

    void Deleted(XClassConstructor x) {
    }

    void Added(XClassConstructor x) {
    }

    void Compare(XClassMethod base, XClassMethod test) {
    }

    void Deleted(XClassMethod x) {
    }

    void Added(XClassMethod x) {
    }

    void Compare(XClassField base, XClassField test) {
    }

    void Deleted(XClassField x) {
    }

    void Added(XClassField x) {
    }

    void Normalize(XClass xclass) {
        if (xclass.IsInterface()) {
            int i;
            xclass.modifier |= 0x400;
            for (i = 0; i < xclass.methods.size(); ++i) {
                ((XClassMethod)xclass.methods.elementAt((int)i)).modifier |= 0x401;
            }
            for (i = 0; i < xclass.fields.size(); ++i) {
                ((XClassField)xclass.fields.elementAt((int)i)).modifier |= 0x19;
            }
        }
    }

    class EqMethod
    extends EqMember {
        EqMethod() {
        }

        public boolean Ident(Object b, Object t) {
            return ((XNode)b).name.equals(((XNode)t).name) && ((XClassMethod)b).args.equals(((XClassMethod)t).args);
        }
    }

    class EqConstructor
    extends EqMember {
        EqConstructor() {
        }

        public boolean Ident(Object b, Object t) {
            return ((XClassConstructor)b).args.equals(((XClassConstructor)t).args);
        }
    }

    class EqMember
    implements Equalizer {
        EqMember() {
        }

        public boolean Ident(Object b, Object t) {
            return ((XNode)b).name.equals(((XNode)t).name);
        }

        public boolean Visible(Object o) {
            XClassMember x = (XClassMember)o;
            if (x.home == null) {
                if (!((XClass)x).defined) {
                    return false;
                }
                switch (XProgComp.this.access) {
                    case 1: 
                    case 2: {
                        return (x.modifier & 1) != 0;
                    }
                }
                return true;
            }
            switch (XProgComp.this.access) {
                case 1: {
                    return (x.modifier & 1) != 0;
                }
                case 2: {
                    return (x.modifier & 5) != 0;
                }
                case 3: {
                    return (x.modifier & 2) == 0;
                }
            }
            return true;
        }
    }

    class EqName
    implements Equalizer {
        EqName() {
        }

        public boolean Ident(Object b, Object t) {
            return ((XNode)b).name.equals(((XNode)t).name);
        }

        public boolean Visible(Object o) {
            return true;
        }
    }
}

