/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 72451 2013-08-06 14:59:31Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.application.applicationWrapperISE;

import java.io.IOException;
import java.io.PrintWriter;

import javax.el.ELResolver;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.resolver.TCKELResolver;
import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.statemanager.TCKStateManager;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;
import com.sun.ts.tests.jsf.common.viewhandler.TCKViewHandler;

public class TestServlet extends HttpTCKServlet {

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		config.getServletContext();
	}

	public void applicationWrapperAddELResolverISETest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		Application application = new TCKAppWrapper().getWrapped();

		JSFTestUtil.checkForISE(application, "addELResolver",
				new Class<?>[] { ELResolver.class }, 
				new Object[] { new TCKELResolver() }, out);

	}

	// Test for ApplicationWrapper.setResourceHandler() throws
	// IllegalStateException
	public void applicationWrapperSetResourceHandlerISETest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		Application application = new TCKAppWrapper().getWrapped();

		JSFTestUtil.checkForISE(application, "setResourceHandler",
				new Class<?>[] { ResourceHandler.class },
				new Object[] { application.getResourceHandler() }, out);
	}

	// Test for ApplicationWrapper.setStateManager() throws
	// IllegalStateException
	public void applicationWrapperSetStateManagerISETest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		Application application = new TCKAppWrapper().getWrapped();

		JSFTestUtil.checkForISE(application, "setStateManager",
				new Class<?>[] { StateManager.class },
				new Object[] { new TCKStateManager() }, out);
	}

	public void applicationWrapperSetViewHandlerISETest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		Application application = new TCKAppWrapper().getWrapped();

		JSFTestUtil.checkForISE(application, "setViewHandler",
				new Class<?>[] { ViewHandler.class },
				new Object[] { new TCKViewHandler() }, out);

	}

	// ------------------------ Private Implementations ------------------------

	private class TCKAppWrapper extends ApplicationWrapper {

		@Override
		public Application getWrapped() {
			return getApplication();
		}

	}

}
