/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BaseActionSource2TestServlet.java 64095 2011-11-23 14:59:12Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.component.common;

import java.io.IOException;
import java.io.PrintWriter;

import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.faces.component.ActionSource2;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;

import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public abstract class BaseActionSource2TestServlet
    extends BaseActionSourceTestServlet {

    private ServletContext servletContext;


    /**
         * <p>Initialize this <code>Servlet</code> instance.</p>
         *
         * @param config the configuration for this <code>Servlet</code>
         *
         * @throws javax.servlet.ServletException indicates initialization failure
         */
    public void init(ServletConfig config) throws ServletException {

        servletContext = config.getServletContext();
        super.init(config);

    } // init


    // ------------------------------------------------------------ Test Methods


    public void actionSource2GetSetActionExpressionTest(HttpServletRequest request,
                                                        HttpServletResponse response)
    throws ServletException, IOException {

        PrintWriter out = response.getWriter();
        request.setAttribute("bean", new SimpleBean());
        ExpressionFactory factory = JspFactory.getDefaultFactory().
            getJspApplicationContext(servletContext).getExpressionFactory();
        MethodExpression expression =
            factory.createMethodExpression(getFacesContext().getELContext(),
                                           "#{bean.action}",
                                           java.lang.String.class,
                                           new Class[] {});
       
        ActionSource2 source2 = (ActionSource2) createComponent();

        source2.setActionExpression(expression);

        if (source2.getActionExpression() != expression) {
            out.println(JSFTestUtil.FAIL + " Unexpected return value from" +
                " getActionExpression() after having just called" +
                " setActionExpression().");
            out.println("Expected: " + expression);
            out.println("Received: " + source2.getActionExpression());
            return;
        }

        out.println(JSFTestUtil.PASS);


    } // END actionSource2GetSetMethodExpressionTest


    // ----------------------------------------------------------- Inner Classes

    private static class SimpleBean {

        public String getAction() {

            return "action";

        } // END getAction

    } // END SimpleBean
}

