/*
 * Copyright (c) 2009, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 68229 2012-10-23 17:16:06Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.convert.localtimeconverter;

import java.io.PrintWriter;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

public final class URLClient extends AbstractUrlClient {

    private static final String CONTEXT_ROOT = "/jsf_convert_localtime_web";
    private static final String TYPE = "localtime";

    public static void main(String[] args) {
	URLClient theTests = new URLClient();
	Status s = theTests.run(args, new PrintWriter(System.out),
		new PrintWriter(System.err));
	s.exit();
    }

    public Status run(String args[], PrintWriter out, PrintWriter err) {
	setContextRoot(CONTEXT_ROOT);
	setServletName(DEFAULT_SERVLET_NAME);
	return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost; webServerPort; ts_home;
     */

    /* Test Declarations */

    /**
     * @testName: LocalTimeConverterGetAsObjectTest
     * @assertion_ids: JSF:JAVADOC:1574; JSF:JAVADOC:1539; JSF:JAVADOC:1540
     * @test_Strategy: Ensure the proper result is returned when passing in a
     *                 valid value, null, or a zero-length String.
     */
    public void LocalTimeConverterGetAsObjectTest() throws Fault {
	TEST_PROPS
	.setProperty(APITEST, "converterGetAsObjectTest&type=" + TYPE);
	invoke();
    }

    /**
     * @testName: LocalTimeConverterGetAsObjectNPETest
     * @assertion_ids: JSF:JAVADOC:1577; JSF:JAVADOC:1539; JSF:JAVADOC:1542
     * @test_Strategy: Ensure an NPE is thrown if either the context or
     *                 component parameters are null.
     */
    public void LocalTimeConverterGetAsObjectNPETest() throws Fault {
	TEST_PROPS
	.setProperty(APITEST, "converterGetAsObjectNPETest&type=" + TYPE);
	invoke();
    }

    /**
     * @testName: LocalTimeConverterGetAsStringTest
     * @assertion_ids: JSF:JAVADOC:1579; JSF:JAVADOC:1539; JSF:JAVADOC:1543
     * @test_Strategy: Ensure the proper result is returned when passing in a
     *                 valid value, null, or a zero-length String.
     */
    public void LocalTimeConverterGetAsStringTest() throws Fault {
	TEST_PROPS
	.setProperty(APITEST, "converterGetAsStringTest&type=" + TYPE);
	invoke();
    }

    /**
     * @testName: LocalTimeConverterGetAsStringNPETest
     * @assertion_ids: JSF:JAVADOC:1539; JSF:JAVADOC:1545
     * @test_Strategy: Ensure an NPE is thrown if either the context or
     *                 component parameters are null.
     */
    public void LocalTimeConverterGetAsStringNPETest() throws Fault {
	TEST_PROPS
	.setProperty(APITEST, "converterGetAsStringNPETest&type=" + TYPE);
	invoke();
    }

} // end of URLClient
