/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ApplicationScopedPrivateBean.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.spec.el.managedbean.common;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.io.Serializable;

public class ApplicationScopedPrivateBean extends ScopedBean implements Serializable {

    private @PostConstruct void onPostConstructPrivate() {
	setPostConstructProperty("application private PostConstruct method invoked");
    }

    private @PreDestroy void onPreDestroy() {
	PreDestroyProp.setPreDestroyProperty("application private PreDestroy method invoked");
    }

    public ApplicationScopedPrivateBean() {
        System.out.println("ApplicationScopedPrivateBean created.");
    }
}
