/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72268 2013-06-28 20:13:09Z dougd $
 */
package com.sun.ts.tests.jsf.spec.jstl.fntolowercase;

import java.io.PrintWriter;
import java.util.Formatter;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.BaseHtmlUnitClient;

public class URLClient extends BaseHtmlUnitClient {

	private static final String SERVLET_MAPPING = "/faces";
	private static final String CONTEXT_ROOT = "/jsf_jstl_fntolowercase_web"
			+ SERVLET_MAPPING;
	private static final String TAG_NAME = "span";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out, true),
				new PrintWriter(System.err, true));
		s.exit();
	}

	public Status run(String[] args, PrintWriter out, PrintWriter err) {
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */
	/**
	 * @testName: jstlFunctiontoLowerCaseTagTest
	 * @assertion_ids: PENDING
	 * @test_Strategy: Validate "fn:toLowerCase" JSTL function tag.
	 * 
	 *                 Test to make sure the following:
	 * 
	 *                 case1: 'lower' == fn:toLowerCase('lOwER') - true case2:
	 *                 '' == fn:toLowerCase(null) - true
	 * 
	 * @since 2.0
	 */
	public void jstlFunctiontoLowerCaseTagTest() throws Fault {
		StringBuilder messages = new StringBuilder(128);
		Formatter formatter = new Formatter(messages);

		HtmlPage page = getPage(CONTEXT_ROOT + "/fntolowercase.xhtml");

		// -------------------------------------------------------------- case 1
		HtmlSpan testOne = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case1");

		if (!validateExistence("case1", TAG_NAME, testOne, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testOne, "true", formatter);

		// -------------------------------------------------------------- case 2
		HtmlSpan testTwo = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case2");

		if (!validateExistence("case2", TAG_NAME, testTwo, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testTwo, "true", formatter);

		handleTestStatus(messages);

	} // END jstlFunctiontoLowerCaseTagTest //
}
