/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: OutputUIComponentBean.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.spec.render.common;

import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.component.html.HtmlOutputText;

public class OutputUIComponentBean {

    private HtmlOutputLabel label;
    private HtmlOutputLink link;
    private HtmlOutputText text;

    // For Output label binding test.
    public HtmlOutputLabel getLabel() {
        return label;
    }

    public void setLabel(HtmlOutputLabel label) {
        label.setStyleClass("text");
        label.setValue("This is an Output UIComponent");

        this.label = label;
    }

    // For Outputlink binding test.
    public HtmlOutputLink getLink() {
        return link;
    }

    public void setLink(HtmlOutputLink link) {
        link.setId("case_three");
        link.setStyleClass("text");
        link.setValue("encodetest.jsp");

        this.link = link;
    }

    // For OutputText binding test.
    public HtmlOutputText getText() {
        return text;
    }

    public void setText(HtmlOutputText text) {
        text.setStyleClass("text");

        this.text = text;
    }
}
