/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 *  $Id: ViewHandlerImpl.java 68708 2012-11-27 15:42:19Z dougd $
 */
package com.sun.ts.tests.jsf.spec.view.viewhandler;

import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class ViewHandlerImpl extends ViewHandlerWrapper {

	protected ViewHandler viewHandler;

	public ViewHandlerImpl(ViewHandler viewHandler) {
		this.viewHandler = viewHandler;
	}

	@Override
	public ViewHandler getWrapped() {
		return viewHandler;
	}

	@Override
	public UIViewRoot createView(FacesContext context, String viewId) {
		UIViewRoot root = this.getWrapped().createView(context, viewId);
		if (!root.getViewId().endsWith(".jsp")) {
			throw new FacesException("createView: ViewId has been "
					+ "manipulated before being passed to the ViewHandler."
					+ JSFTestUtil.NL + "Expected viewId: /greetings.jsp"
					+ JSFTestUtil.NL + "Received viewId: " + viewId
					+ JSFTestUtil.NL);
		}
		return root;
	}

	@Override
	public UIViewRoot restoreView(FacesContext context, String viewId) {
		UIViewRoot root = this.getWrapped().restoreView(context, viewId);
		if (!root.getViewId().endsWith(".jsp")) {
			throw new FacesException("restoreView: ViewId has been "
					+ "manipulated before being passed to the ViewHandler. "
					+ JSFTestUtil.NL + "Expected viewId: /greetings.jsp"
					+ JSFTestUtil.NL + "Received viewId: " + viewId
					+ JSFTestUtil.NL);
		}
		return root;
	}
}