<%--
  Copyright 2009, Oracle and its affiliates. All rights reserved.
  ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 
  @(#)encodetestBasic.jsp	1.2 06/01/31
--%>

<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>

<html>
    <head>
        <title>encodetestBasic</title> 
        <style type="text/css">
            .odd {
                color: cadetblue;
            }
            .even {
                color: darkgray;
            }
        </style>
    </head>
    
    <body>
        <f:view>
            <%-- 
        Most basic table - no facets
            --%>
            <h:panelGrid id="grid1" styleClass="color: yellow;" >
                <h:column>
                    <h:outputText value="3"/>
                </h:column>
                <h:column>
                    <h:outputText value="7"/>
                </h:column>
                <h:column>
                    <h:outputText value="31"/>
                </h:column>
                <h:column>
                    <h:outputText value="127"/>
                </h:column>
                <h:column>
                    <h:outputText value="8191"/>
                </h:column>
                <h:column>
                    <h:outputText value="131071"/>
                </h:column>
            </h:panelGrid>    
            
            <h:panelGrid id="grid2" styleClass="color: yellow;" 
                         columns="2" >
                <h:column>
                    <h:outputText value="3"/>
                </h:column>
                <h:column>
                    <h:outputText value="7"/>
                </h:column>
                <h:column>
                    <h:outputText value="31"/>
                </h:column>
                <h:column>
                    <h:outputText value="127"/>
                </h:column>
                <h:column>
                    <h:outputText value="8191"/>
                </h:column>
                <h:column>
                    <h:outputText value="131071"/>
                </h:column>
            </h:panelGrid>    
            
            <h:panelGrid id="grid3" styleClass="color: yellow;" 
                         columns="3" >
                <h:column>
                    <h:outputText value="3"/>
                </h:column>
                <h:column>
                    <h:outputText value="7"/>
                </h:column>
                <h:column>
                    <h:outputText value="31"/>
                </h:column>
                <h:column>
                    <h:outputText value="127"/>
                </h:column>
                <h:column>
                    <h:outputText value="8191"/>
                </h:column>
                <h:column>
                    <h:outputText value="131071"/>
                </h:column>
            </h:panelGrid>    
            
            <h:panelGrid id="grid4" styleClass="color: yellow;" 
                         columns="6" >
                <h:column>
                    <h:outputText value="3"/>
                </h:column>
                <h:column>
                    <h:outputText value="7"/>
                </h:column>
                <h:column>
                    <h:outputText value="31"/>
                </h:column>
                <h:column>
                    <h:outputText value="127"/>
                </h:column>
                <h:column>
                    <h:outputText value="8191"/>
                </h:column>
                <h:column>
                    <h:outputText value="131071"/>
                </h:column>
            </h:panelGrid>    
            
            <%--
        Same as grid3 , but mix in rowClasses and columnClasses
            --%>
            <h:panelGrid id="grid5" 
                         columns="3"
                         rowClasses="odd,even"
                         columnClasses="even,odd,even">
                <h:column>
                    <h:outputText value="3"/>
                </h:column>
                <h:column>
                    <h:outputText value="7"/>
                </h:column>
                <h:column>
                    <h:outputText value="31"/>
                </h:column>
                <h:column>
                    <h:outputText value="127"/>
                </h:column>
                <h:column>
                    <h:outputText value="8191"/>
                </h:column>
                <h:column>
                    <h:outputText value="131071"/>
                </h:column>
            </h:panelGrid>
            
            <%--
            Test the binding attribute.
            --%>
            <h:panelGrid id="grid6" binding="#{location.gps}"/>
            
        </f:view>
    </body>
</html>
