/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model;

import com.sun.ts.tests.jsonb.TypeContainer;

import java.util.Optional;

public class OptionalContainer implements TypeContainer<Optional<String>> {
    private Optional<String> instance;

    @Override
    public Optional<String> getInstance() {
        return instance;
    }

    @Override
    public void setInstance(Optional<String> instance) {
        this.instance = instance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OptionalContainer)) return false;

        OptionalContainer that = (OptionalContainer) o;

        return instance != null ? instance.equals(that.instance) : that.instance == null;
    }

    @Override
    public int hashCode() {
        return instance != null ? instance.hashCode() : 0;
    }
}
