/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model;

import com.sun.ts.tests.jsonb.TypeContainer;

import java.util.OptionalInt;

public class OptionalIntContainer implements TypeContainer<OptionalInt> {
    private OptionalInt instance;

    @Override
    public OptionalInt getInstance() {
        return instance;
    }

    @Override
    public void setInstance(OptionalInt instance) {
        this.instance = instance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OptionalIntContainer)) return false;

        OptionalIntContainer that = (OptionalIntContainer) o;

        return instance != null ? instance.equals(that.instance) : that.instance == null;
    }

    @Override
    public int hashCode() {
        return instance != null ? instance.hashCode() : 0;
    }
}
