/*
 * Copyright (c) 2017 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.jsonobjecttests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

import static com.sun.ts.tests.jsonp.api.common.JsonAssert.*;
import static com.sun.ts.tests.jsonp.api.common.SimpleValues.*;

// $Id: CreateObjectBuilder.java 74775 2017-01-11 10:46:06Z tkraus $
/**
 * JavaScript Object Notation (JSON) compatibility tests:
 * {@link JsonObjectBuilder} API factory methods added in JSON-P 1.1.<br>
 */
public class CreateObjectBuilder {
    
    /**
     * Creates an instance of {@link JsonObjectBuilder} API factory methods added in JSON-P 1.1 test.
     */
    CreateObjectBuilder() {
        super();
    }

    /**
     * Test {@link JsonObjectBuilder} factory method added in JSON-P 1.1.
     * @return Result of all tests in this suite.
     */
    TestResult test() {
        final TestResult result = new TestResult("JsonObjectBuilder API factory methods added in JSON-P 1.1.");
        TestUtil.logMsg("JsonObjectBuilder API factory methods added in JSON-P 1.1.");
        testCreateFromMap(result);
        testCreateFromJsonObject(result);
        return result;
    }

    /**
     * Test {@link Json#createObjectBuilder(Map<String,Object>)} method.
     * @param result Test suite result.
     */
    private void testCreateFromMap(final TestResult result) {
        TestUtil.logMsg(" - Json#createObjectBuilder(Map<String,Object>)");
        final JsonObject check = createSimpleObjectWithStr();
        Map<String,Object> values = new HashMap<>(2);
        values.put(DEF_NAME, DEF_VALUE);
        values.put(STR_NAME, STR_VALUE);
        final JsonObjectBuilder builder = Json.createObjectBuilder(values);
        final JsonObject out = builder.build();
        if (operationFailed(check, out)) {
                result.fail("createObjectBuilder(Map<String,Object>)",
                        "Builder output " + valueToString(out) + " value shall be " + valueToString(check));
        }
    }

    /**
     * Test {@link Json#createObjectBuilder(JsonObject)} method.
     * @param result Test suite result.
     */
    private void testCreateFromJsonObject(final TestResult result) {
        TestUtil.logMsg(" - Json#createObjectBuilder(JsonObject)");
        final JsonObject check = createSimpleObjectWithStr();
        final JsonObjectBuilder builder = Json.createObjectBuilder(check);
        final JsonObject out = builder.build();
        if (operationFailed(check, out)) {
                result.fail("reateObjectBuilder(JsonObject)",
                        "Builder output " + valueToString(out) + " value shall be " + valueToString(check));
        }
    }

    /**
     * Operation result check.
     * @param check Expected modified JSON value.
     * @param out Operation output.
     * @return Value of {@code true} if operation passed or {@code false} otherwise.
     */
    protected boolean operationFailed(final JsonValue check, final JsonValue out) {
        return out == null || !assertEquals(check, out);
    }

}
