/*
 * Copyright (c) 2016-2017 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.common.JsonPTest;

// $Id: PatchTests.java 74776 2017-01-11 10:51:15Z tkraus $
/*
 * RFC 6902: JavaScript Object Notation (JSON) Patch compatibility tests.<br>
 * {@see <a href="https://tools.ietf.org/html/rfc6902">RFC 6902</a>}.
 */
public class PatchTests extends JsonPTest {

    /**
     * Test {@link JsonPatch} factory methods added in JSON-P 1.1.
     *
     * @throws Fault when this test failed.
     *
     * @testName:      jsonCreatePatch11Test
     *
     * @assertion_ids: JSONP:JAVADOC:574; JSONP:JAVADOC:579; JSONP:JAVADOC:581; JSONP:JAVADOC:653; JSONP:JAVADOC:658;
     *                 JSONP:JAVADOC:660; JSONP:JAVADOC:620; JSONP:JAVADOC:621;
     *
     * @test_Strategy: Tests JsonPatch API factory methods added in JSON-P 1.1.
     */
    public void jsonCreatePatch11Test() throws Fault {
        PatchCreate createTest = new PatchCreate();
        final TestResult result = createTest.test();
        result.eval();
    }

    /**
     * Test {@code JsonPatch.Operation} enumeration added in JSON-P 1.1.
     *
     * @throws Fault when this test failed.
     *
     * @testName:      jsonJsonPatchOperation11Test
     *
     * @assertion_ids: JSONP:JAVADOC:622; JSONP:JAVADOC:623; JSONP:JAVADOC:624; JSONP:JAVADOC:625;
     *
     * @test_Strategy: Tests JsonPatch.Operation enumeration added in JSON-P 1.1.
     */
    public void jsonJsonPatchOperation11Test() throws Fault {
        PatchOperationEnum enumTest = new PatchOperationEnum();
        final TestResult result = enumTest.test();
        result.eval();
    }

    /**
     * Test JSONP API response on add operation.<br>
     * {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.1">RFC 6902: 4.1. add</a>}.
     *
     * @throws Fault when this test failed.

     * @testName:      jsonPatchAddTest
     * @assertion_ids: JSONP:JAVADOC:626; JSONP:JAVADOC:627; JSONP:JAVADOC:628; JSONP:JAVADOC:629; JSONP:JAVADOC:580;
     *                 JSONP:JAVADOC:659; JSONP:JAVADOC:620; JSONP:JAVADOC:630;
     * @test_Strategy: Test API response on various usages of add operation.
     */
    public void jsonPatchAddTest() throws Fault {
        PatchOperationAdd addTest = new PatchOperationAdd();
        final TestResult result = addTest.test();
        result.eval();
    }

    /**
     * Test JSONP API response on remove operation.<br>
     * {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.2">RFC 6902: 4.2. remove</a>}.
     *
     * @throws Fault when this test failed.
     *
     * @testName:      jsonPatchRemoveTest
     * @assertion_ids: JSONP:JAVADOC:633; JSONP:JAVADOC:580; JSONP:JAVADOC:659; JSONP:JAVADOC:620; JSONP:JAVADOC:630;
     * @test_Strategy: Test API response on various usages of remove operation.
     */
    public void jsonPatchRemoveTest() throws Fault {
        PatchOperationRemove removeTest = new PatchOperationRemove();
        final TestResult result = removeTest.test();
        result.eval();
    }

    /**
     * Test JSONP API response on replace operation.<br>
     * {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.3">RFC 6902: 4.3. replace</a>}.
     *
     * @throws Fault when this test failed.
     *
     * @testName:      jsonPatchReplaceTest
     * @assertion_ids: JSONP:JAVADOC:634; JSONP:JAVADOC:635; JSONP:JAVADOC:636; JSONP:JAVADOC:637; JSONP:JAVADOC:580;
     *                 JSONP:JAVADOC:659; JSONP:JAVADOC:620; JSONP:JAVADOC:630;
     * @test_Strategy: Test API response on various usages of replace operation.
     */
    public void jsonPatchReplaceTest() throws Fault {
        PatchOperationReplace replaceTest = new PatchOperationReplace();
        final TestResult result = replaceTest.test();
        result.eval();
    }

    /**
     * Test JSONP API response on move operation.<br>
     * {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.4">RFC 6902: 4.4. move</a>}.
     *
     * @throws Fault when this test failed.
     *
     * @testName:      jsonPatchMoveTest
     * @assertion_ids: JSONP:JAVADOC:632; JSONP:JAVADOC:580; JSONP:JAVADOC:659; JSONP:JAVADOC:620; JSONP:JAVADOC:630;
     * @test_Strategy: Test API response on various usages of move operation.
     */
    public void jsonPatchMoveTest() throws Fault {
        PatchOperationMove moveTest = new PatchOperationMove();
        final TestResult result = moveTest.test();
        result.eval();
    }

    /**
     * Test JSONP API response on copy operation.<br>
     * {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.5">RFC 6902: 4.5. copy</a>}.
     *
     * @throws Fault when this test failed.
     *
     * @testName:      jsonPatchCopyTest
     * @assertion_ids: JSONP:JAVADOC:631; JSONP:JAVADOC:580; JSONP:JAVADOC:659; JSONP:JAVADOC:620; JSONP:JAVADOC:630;
     * @test_Strategy: Test API response on various usages of copy operation.
     */
    public void jsonPatchCopyTest() throws Fault {
        PatchOperationCopy copyTest = new PatchOperationCopy();
        final TestResult result = copyTest.test();
        result.eval();
    }

    /**
     * Test JSONP API response on test operation.<br>
     * {@see <a href="https://tools.ietf.org/html/rfc6902#section-4.6">RFC 6902: 4.6. test</a>}.
     *
     * @throws Fault when this test failed.
     *
     * @testName:      jsonPatchTestTest
     * @assertion_ids: JSONP:JAVADOC:638; JSONP:JAVADOC:639; JSONP:JAVADOC:640; JSONP:JAVADOC:641; JSONP:JAVADOC:580;
     *                 JSONP:JAVADOC:659; JSONP:JAVADOC:620; JSONP:JAVADOC:630;
     * @test_Strategy: Test API response on various usages of test operation.
     */
    public void jsonPatchTestTest() throws Fault {
        PatchOperationTest testTest = new PatchOperationTest();
        final TestResult result = testTest.test();
        result.eval();
    }

}
