/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyBufferedReader.java 69257 2012-12-20 15:38:14Z adf $
 */

package com.sun.ts.tests.jsonp.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import java.io.*;

// A wrapper class to BufferedReader class used to inject IOException errors
// when the throwIOException instance variable is set. All methods delegate
// to the parent super class and check whether or not to throw an IOException
// before delegation.

public class MyBufferedReader extends BufferedReader {

  private boolean throwIOException;

  public MyBufferedReader(Reader in) {
	super(in);
  }

  public MyBufferedReader(Reader in, int sz) {
	super(in, sz);
  }

  public MyBufferedReader(Reader in, int sz, boolean throwIOException) {
	super(in, sz);
	this.throwIOException = throwIOException;
  }

  private void checkToTripIOException() throws IOException {
	if (throwIOException) {
	    TestUtil.logMsg("*** tripping an IOException ***");
	    throw new IOException("tripping an IOException");
	}
  }

  public void setThrowIOException(boolean throwIOException) {
	this.throwIOException = throwIOException;
  }

  public int read() throws IOException {
	checkToTripIOException();
	return super.read();
  }

  public int read(char[] cbuf, int off, int len) throws IOException {
	checkToTripIOException();
	return super.read(cbuf, off, len);
  }

  public String readLine() throws IOException {
	checkToTripIOException();
	return super.readLine();
  }

  public boolean ready() throws IOException {
	checkToTripIOException();
	return super.ready();
  }

  public void reset() throws IOException {
	checkToTripIOException();
	super.reset();
  }

  public void close() throws IOException {
	checkToTripIOException();
	super.close();
  }
}
