/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.DeliverableInterface;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.deliverable.PropertyNotSetException;
import com.sun.ts.lib.harness.ExecutionMode;
import com.sun.ts.lib.harness.SuiteSynchronizer;
import com.sun.ts.lib.harness.TSTestFinder;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.porting.TSJMSAdminException;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class TSHarnessObserver
implements Harness.Observer,
TestResult.Observer {
    private boolean supportsAutoDeploy = true;
    private boolean supportsAutoJMSAdmin = true;
    private static SuiteSynchronizer ss;
    private static int iPassedCount;
    private static int iFailedCount;
    private static int iErrorCount;
    private static int iNotRunCount;
    private static int iFinishedTests;
    private static int iRemainingTests;
    private static int iTotalTestsFound;
    private static Vector vTests;
    private static boolean jtrOutput;
    private static String sLastTestDirectory;
    private static int executionMode;
    private static String keywords;
    private static final String SEP = "*******************************";
    private static final String SEP2 = "********************************************************************************";
    private PrintWriter logDeploy;
    private StringWriter logLastDeployOutput;

    public TSHarnessObserver() {
        try {
            DeliverableInterface deliverable = DeliverableFactory.getDeliverableInstance();
            this.supportsAutoDeploy = deliverable.supportsAutoDeployment();
            this.supportsAutoJMSAdmin = deliverable.supportsAutoJMSAdmin();
        }
        catch (Exception ex) {
            TestUtil.logHarness("Failed to get deliverable instance.");
            ex.printStackTrace();
        }
    }

    public void startingTestRun(Parameters p) {
        if (jtrOutput) {
            this.println("Starting tests");
        }
        PropertyManagerInterface propMgr = null;
        try {
            Parameters.MutableKeywordsParameters mkp = (Parameters.MutableKeywordsParameters)p.getKeywordsParameters();
            keywords = mkp.getMatchKeywordsValue();
            TestUtil.logHarness("startingTestRun - keywords set to:  " + keywords);
            if (keywords == null) {
                keywords = "all";
            }
            propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            propMgr.setProperty("current.keywords", keywords);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        executionMode = ExecutionMode.getExecutionMode(propMgr);
    }

    public void stoppingTestRun() {
    }

    public void finishedTestRun(boolean allOK) {
    }

    public synchronized void finishedTesting() {
        PropertyManagerInterface propMgr = null;
        try {
            propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            if (keywords == null) {
                keywords = "all";
            }
            propMgr.setProperty("current.keywords", keywords);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (executionMode == 0 || executionMode == 3) {
                ss = SuiteSynchronizer.getSuiteSynchronizer(new PrintWriter(System.out, true));
                sLastTestDirectory = "";
                if (this.supportsAutoDeploy) {
                    ss.undeployLastApp();
                    ss.doCommonUnDeployment();
                }
                if (this.supportsAutoJMSAdmin) {
                    ss.removeJmsConnectionFactories();
                }
            }
        }
        catch (TSDeploymentException de) {
            TestUtil.logHarness("*******************************\nAn error occurred during common/last app Undeployment\n*******************************");
            de.printStackTrace();
        }
        catch (TSJMSAdminException je) {
            TestUtil.logHarness("*******************************\nAn error occurred during JMS topic/queue/factory removal\n*******************************");
            je.printStackTrace();
        }
        if (jtrOutput) {
            int iSize = vTests.size();
            if (iSize == 0) {
                return;
            }
            StringBuffer msg = new StringBuffer(1000);
            msg.append(SEP2).append('\n');
            if (executionMode == 5) {
                msg.append("Listing of tests in this directory: ").append(iFinishedTests).append(" tests found.").append('\n');
                Iterator it = TSTestFinder.htTestNamesFound.entrySet().iterator();
                boolean bHeaderWritten = false;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String sKey = (String)entry.getKey();
                    Integer iValue = (Integer)entry.getValue();
                    if (iValue <= 1) continue;
                    if (!bHeaderWritten) {
                        msg.append('\n');
                        msg.append("Found duplicate @testName declarations").append('\n');
                        msg.append("------------------------------------------------------").append('\n');
                        bHeaderWritten = true;
                    }
                    msg.append(iValue + " occurrences of " + sKey.substring(sKey.indexOf("com" + File.separator))).append('\n');
                }
                msg.append('\n');
            } else {
                msg.append("Completed running ").append(iFinishedTests).append(" tests.").append('\n');
                msg.append("Number of Tests Passed      = ").append(iPassedCount).append('\n');
                msg.append("Number of Tests Failed      = " + iFailedCount).append('\n');
                msg.append("Number of Tests with Errors = " + iErrorCount).append('\n');
            }
            msg.append(SEP2).append('\n');
            for (int ii = 0; ii < iSize; ++ii) {
                String elem = (String)vTests.get(ii);
                msg.append(elem).append('\n');
            }
            this.println(msg.toString());
            vTests.removeAllElements();
            iFinishedTests = 0;
            iPassedCount = 0;
            iErrorCount = 0;
            iNotRunCount = 0;
            iFailedCount = 0;
            iTotalTestsFound = 0;
        }
        this.removeTempPropsFile();
        this.removeTempJars();
    }

    private void removeTempPropsFile() {
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            String userName = System.getProperty("user.name");
            String tempFile = tempDir + File.separator + userName + "-cts-props.txt";
            File tempF = new File(tempFile);
            tempF.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeTempJars() {
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            File tempDirFile = new File(tempDir);
            String userName = System.getProperty("user.name");
            File[] tempJars = tempDirFile.listFiles();
            int numFiles = tempJars == null ? 0 : tempJars.length;
            for (int i = 0; i < numFiles; ++i) {
                if (!tempJars[i].getName().startsWith(userName + "-ts-deployment-plan") || !tempJars[i].getName().endsWith(".jar")) continue;
                try {
                    tempJars[i].delete();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void error(String s) {
        TestUtil.logHarness(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startingTest(TestResult tr) {
        Properties pTestProps = null;
        String sVehicle = "";
        String sIsServiceTest = "";
        PropertyManagerInterface propMgr = null;
        try {
            propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            if (keywords == null) {
                TestUtil.logHarness("startingTest - resetting keywords set to:  all");
                keywords = "all";
            }
            propMgr.setProperty("current.keywords", keywords);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestDescription td = null;
        try {
            td = tr.getDescription();
        }
        catch (TestResult.Fault e) {
            e.printStackTrace();
        }
        if (jtrOutput) {
            tr.addObserver((TestResult.Observer)this);
            if (executionMode == 0 || executionMode == 2 || executionMode == 4) {
                StringBuffer msg = new StringBuffer(300);
                msg.append(SEP2).append('\n');
                msg.append("Beginning Test:  ").append(td.getParameter("classname").replace('.', '/')).append(".java#").append(td.getParameter("id")).append('\n');
                msg.append(SEP2).append('\n');
                this.println(msg.toString());
            }
        }
        if (ss == null) {
            ss = SuiteSynchronizer.getSuiteSynchronizer(new PrintWriter(System.out, true));
        }
        String testPropsInDescp = td.getParameter("testProps");
        String[] sTestPropKeys = TestUtil.EMPTY_STRING_ARRAY;
        if (testPropsInDescp != null) {
            StringTokenizer st = new StringTokenizer(testPropsInDescp.trim());
            sTestPropKeys = new String[st.countTokens()];
            for (int ii = 0; ii < sTestPropKeys.length; ++ii) {
                sTestPropKeys[ii] = st.nextToken();
            }
        }
        try {
            pTestProps = propMgr.getTestSpecificProperties(sTestPropKeys);
        }
        catch (PropertyNotSetException e) {
            e.printStackTrace();
        }
        String sID = td.getParameter("id");
        sIsServiceTest = td.getParameter("service_eetest");
        sVehicle = null;
        sVehicle = sIsServiceTest.equals("yes") ? sID.substring(sID.lastIndexOf("_") + 1) : "not a service test";
        if (this.supportsAutoDeploy) {
            String testDir = "";
            testDir = TSTestFinder.getAbsolutePath(td.getParameter("test_directory"));
            if (!sVehicle.equals("standalone") || testDir.indexOf("jaxrs") != -1) {
                TestResult.Section deploySection = tr.createSection("Deployment");
                this.logDeploy = deploySection.createOutput("log");
                try {
                    if (sLastTestDirectory.equals(testDir)) {
                        if (ss.getDeploymentStatus().equals("failed")) {
                            TestUtil.logHarness("An error ocurred during deployment of apps in this directory:  " + testDir + ".  Thus, all other tests in this directory will fail with the same error.");
                        }
                    } else {
                        this.logLastDeployOutput = new StringWriter();
                        TestUtil.setAdditionalWriter(new PrintWriter(this.logLastDeployOutput));
                        sLastTestDirectory = testDir;
                        ss.doDeployment(testDir, pTestProps);
                    }
                }
                catch (TSDeploymentException tSDeploymentException) {
                }
                catch (TSJMSAdminException je) {
                    TestUtil.logHarness("*******************************\nAn error occurred during JMS topic/queue creation/removal\n*******************************");
                    je.printStackTrace();
                }
                finally {
                    this.logDeploy.write(this.logLastDeployOutput.getBuffer().toString());
                    deploySection.setStatus(new Status(0, "Deployment phase completed.  However, check the output above to see if actual deployment passed or failed."));
                    this.logDeploy.close();
                }
            }
        }
    }

    public synchronized void finishedTest(TestResult tr) {
        if (!jtrOutput) {
            return;
        }
        TestDescription td = null;
        String sTestName = "";
        String sClassName = "";
        String sTestNameAndStatus = "";
        try {
            td = tr.getDescription();
        }
        catch (TestResult.Fault e) {
            e.printStackTrace();
        }
        sTestName = td.getParameter("id");
        sClassName = td.getParameter("classname");
        Status sTestStatus = tr.getStatus();
        iTotalTestsFound = tr.getParent().getEnclosingTable().getCurrentTestCount();
        if (executionMode == 0 || executionMode == 2 || executionMode == 4 || executionMode == 5) {
            if (executionMode == 5) {
                sTestNameAndStatus = "NOT_RUN........" + sClassName.replace('.', '/') + ".java#" + sTestName;
                ++iNotRunCount;
            } else if (sTestStatus.getType() == 0) {
                sTestNameAndStatus = "PASSED........" + sClassName.replace('.', '/') + ".java#" + sTestName;
                ++iPassedCount;
            } else if (sTestStatus.getType() == 2) {
                sTestNameAndStatus = "ERROR........" + sClassName.replace('.', '/') + ".java#" + sTestName;
                ++iErrorCount;
            } else if (sTestStatus.getType() == 3) {
                sTestNameAndStatus = "NOT RUN........" + sClassName.replace('.', '/') + ".java#" + sTestName;
                ++iNotRunCount;
            } else {
                sTestNameAndStatus = "FAILED........" + sClassName.replace('.', '/') + ".java#" + sTestName;
                ++iFailedCount;
            }
            vTests.addElement(sTestNameAndStatus);
            iRemainingTests = iTotalTestsFound - ++iFinishedTests;
            StringBuffer msg = new StringBuffer(400);
            msg.append(SEP2).append('\n');
            msg.append("Finished Test:  ").append(sTestNameAndStatus).append('\n');
            msg.append(SEP2).append('\n');
            msg.append("Number of tests completed:  ").append(iFinishedTests).append(" (");
            msg.append(iPassedCount).append(" passed, ").append(iFailedCount).append(" failed, ").append(iErrorCount).append(" with errors)");
            msg.append('\n');
            msg.append("Number of tests remaining:  " + iRemainingTests);
            this.println(sTestStatus.toString());
            this.println(msg.toString());
        } else if (executionMode == 1 || executionMode == 3) {
            if (sTestStatus.getType() == 0 && sTestStatus.getReason().equals("DEPLOYED")) {
                ++iPassedCount;
            } else if (sTestStatus.getType() == 2) {
                ++iErrorCount;
            } else if (sTestStatus.getType() == 3) {
                ++iNotRunCount;
            } else {
                ++iFailedCount;
            }
        }
    }

    public void createdSection(TestResult tr, TestResult.Section section) {
    }

    public void completedSection(TestResult tr, TestResult.Section section) {
    }

    public void createdOutput(TestResult tr, TestResult.Section section, String outputName) {
    }

    public void completedOutput(TestResult tr, TestResult.Section section, String outputName) {
    }

    public void updatedOutput(TestResult tr, TestResult.Section section, String outputName, int start, int end, String text) {
        this.print(text);
    }

    public void updatedProperty(TestResult tr, String name, String value) {
    }

    public void completed(TestResult tr) {
    }

    private void println(String msg) {
        if (jtrOutput) {
            System.out.println(msg);
        }
    }

    private void print(String msg) {
        if (jtrOutput) {
            System.out.print(msg);
        }
    }

    static {
        vTests = new Vector();
        sLastTestDirectory = "";
        keywords = "all";
        jtrOutput = Boolean.getBoolean("cts.jtroutput");
    }
}

