/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.el.scopedattrelresolver;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import com.sun.ts.tests.jsp.common.util.JspResolverTest;
import javax.el.ELContext;
import javax.servlet.jsp.el.ScopedAttributeELResolver;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class ScopedAttrELResolverTag extends SimpleTagSupport {

    public void doTag() throws JspException, IOException {

        StringBuffer buf = new StringBuffer();
        JspWriter out = getJspContext().getOut();
        ELContext context = getJspContext().getELContext();
        ScopedAttributeELResolver scopedattrResolver = new ScopedAttributeELResolver(); 

        try {
            boolean pass = JspResolverTest.testScopedAttrELResolver(
                    context, scopedattrResolver, null, "foo", "bar", buf);
            out.println(buf.toString());
            if (pass == true) out.println("Test PASSED");
        } catch (Throwable t) {
            out.println("contents of buffer:\n" + buf.toString());
            JspTestUtil.handleThrowable(t, out, "ScopedAttrELResolverTag");
        }
    }
}
